/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.JavaTestUtil;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.testFramework.JavaInspectionTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.JavaTestFixtureFactory;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.siyeh.ig.LightJavaInspectionTestCase;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.junit.ComparisonFailure;

class LightTestMigration {
    private static final boolean TREAT_MULTI_FILES_AS_MULTIPLE_TESTS = false;
    private final String myName;
    private final Class<? extends JavaInspectionTestCase> myTestClass;
    private final Path myDir;
    private final List<InspectionToolWrapper<?, ?>> myTools;
    private final List<String> myTestNames = new ArrayList<String>();
    private static LightTestMigration ourPrevious;
    private Path myBaseDir;
    private Path myBasePath;

    LightTestMigration(String name, Class<? extends JavaInspectionTestCase> testClass, String dir, List<InspectionToolWrapper<?, ?>> tools) {
        this.myName = name;
        this.myTestClass = testClass;
        this.myDir = Paths.get(dir, new String[0]);
        this.myTools = tools;
    }

    void tryMigrate() throws Exception {
        this.myBasePath = Paths.get(JavaTestUtil.getJavaTestDataPath(), new String[0]);
        List<Path> files = Collections.singletonList(LightTestMigration.getSoleJavaFile(this.myDir));
        ArrayList<Pair<Path, String>> resultFiles = new ArrayList<Pair<Path, String>>();
        for (Path path : files) {
            resultFiles.add(this.processSingleFileTest(path));
        }
        FileUtil.delete((File)this.myDir.toFile());
        Files.createDirectories(this.myDir, new FileAttribute[0]);
        for (Pair pair : resultFiles) {
            Files.write((Path)pair.getFirst(), ((String)pair.getSecond()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            System.out.println("Written: " + pair.getFirst());
        }
    }

    private Pair<Path, String> processSingleFileTest(Path javaFile) throws Exception {
        String fileText = new String(Files.readAllBytes(javaFile), StandardCharsets.UTF_8);
        String testName = this.myName.isEmpty() ? javaFile.getFileName().toString().replaceFirst(".java$", "") : this.myName;
        this.myBaseDir = this.myName.isEmpty() ? this.myDir : this.myDir.getParent();
        Path targetFile = this.myBaseDir.resolve(testName + ".java");
        IdeaTestFixtureFactory factory = IdeaTestFixtureFactory.getFixtureFactory();
        LightProjectDescriptor descriptor = new LightProjectDescriptor();
        TestFixtureBuilder fixtureBuilder = factory.createLightFixtureBuilder(descriptor);
        IdeaProjectTestFixture fixture = (IdeaProjectTestFixture)fixtureBuilder.getFixture();
        JavaCodeInsightTestFixture javaFixture = JavaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, (TempDirTestFixture)new LightTempDirTestFixtureImpl(true));
        javaFixture.setUp();
        for (InspectionToolWrapper<?, ?> tool : this.myTools) {
            javaFixture.enableInspections(new InspectionProfileEntry[]{tool.getTool()});
            Project project = javaFixture.getProject();
            HighlightDisplayKey displayKey = HighlightDisplayKey.find((String)tool.getShortName());
            InspectionProfileImpl currentProfile = ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile();
            HighlightDisplayLevel errorLevel = currentProfile.getErrorLevel(displayKey, null);
            if (errorLevel != HighlightDisplayLevel.DO_NOT_SHOW) continue;
            currentProfile.setErrorLevel(displayKey, HighlightDisplayLevel.WARNING, project);
        }
        String expectedText = LightTestMigration.getExpectedText(javaFile, fileText, javaFixture);
        LightTestMigration.enqueue(this, testName);
        javaFixture.tearDown();
        return Pair.create((Object)targetFile, (Object)expectedText);
    }

    private void generateClassTemplate() {
        String pathSpec;
        Set importedClasses = StreamEx.of(this.myTools.stream().map(wrapper -> wrapper.getTool().getClass())).append((Object[])new Class[]{LightJavaCodeInsightFixtureTestCase.class, LightProjectDescriptor.class, NotNull.class}).toSet();
        if (this.myBaseDir.startsWith(this.myBasePath)) {
            Path relativePath = this.myBasePath.relativize(this.myBaseDir);
            importedClasses.add(JavaTestUtil.class);
            pathSpec = "JavaTestUtil.getRelativeJavaTestDataPath() + \"/" + StringUtil.escapeStringCharacters((String)relativePath.toString().replace('\\', '/')) + "\"";
        } else {
            Path basePath = Paths.get(PathManagerEx.getCommunityHomePath(), new String[0]);
            if (this.myBaseDir.startsWith(basePath)) {
                Path relativePath = basePath.relativize(this.myBaseDir);
                String pathText = "/" + relativePath.toString().replace('\\', '/');
                if (pathText.startsWith("/plugins/InspectionGadgets/test/")) {
                    importedClasses.add(LightJavaInspectionTestCase.class);
                    pathSpec = "LightInspectionTestCase.INSPECTION_GADGETS_TEST_DATA_PATH + \"" + StringUtil.escapeStringCharacters((String)pathText.substring("/plugins/InspectionGadgets/test/".length())) + "\"";
                } else {
                    pathSpec = "\"" + StringUtil.escapeStringCharacters((String)pathText) + "\"";
                }
            } else {
                pathSpec = "\"!!! Unable to convert path!!! " + StringUtil.escapeStringCharacters((String)this.myBaseDir.toString()) + "\"";
            }
        }
        String imports = this.generateImports(importedClasses);
        String testMethods = this.myTestNames.stream().map(name -> "  public void test" + name + "() {\n    doTest();\n  }\n\n").collect(Collectors.joining());
        String inspections = this.myTools.stream().map(InspectionToolWrapper::getTool).map(Object::getClass).map(Class::getSimpleName).map(name -> "new " + name + "()").collect(Collectors.joining(", "));
        String year = Year.now().toString();
        String classTemplate = MessageFormat.format("// Copyright 2000-{6} JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.\npackage {0};\n\n{1}\npublic class {2} extends LightCodeInsightFixtureTestCase '{'\n  @Override\n  protected String getBasePath() '{'\n    return {3};\n  '}'\n\n  private void doTest() '{'\n    myFixture.enableInspections({4});\n    myFixture.testHighlighting(getTestName(false) + \".java\");\n  '}'\n\n{5}'}'\n", this.myTestClass.getPackage().getName(), imports, this.myTestClass.getSimpleName(), pathSpec, inspections, testMethods, year);
        System.out.println("Class template: (" + this.myTestClass.getSimpleName() + ".java)");
        System.out.println("==============================");
        System.out.println(classTemplate);
        System.out.println("==============================");
    }

    private String generateImports(Set<Class<?>> importedClasses) {
        return importedClasses.stream().filter(cls -> !cls.getPackage().equals(this.myTestClass.getPackage())).map(Class::getName).sorted().map(name -> "import " + name + ";\n").collect(Collectors.joining());
    }

    private static String getExpectedText(Path javaFile, String fileText, JavaCodeInsightTestFixture javaFixture) {
        javaFixture.configureByText(javaFile.getFileName().toString(), fileText);
        try {
            javaFixture.testHighlighting(true, false, false, new String[0]);
        }
        catch (ComparisonFailure e) {
            return e.getActual();
        }
        return fileText;
    }

    private static Path getSoleJavaFile(Path dir) throws IOException {
        List<Path> javaFiles = LightTestMigration.getJavaFiles(dir);
        if (javaFiles.size() > 1) {
            throw new RuntimeException("Unable to migrate: more than one Java file found in " + dir);
        }
        return javaFiles.get(0);
    }

    @NotNull
    private static List<Path> getJavaFiles(Path dir) throws IOException {
        List<Path> javaFiles = Files.walk(dir, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".java")).filter(p -> Files.isRegularFile(p, new LinkOption[0])).collect(Collectors.toList());
        if (javaFiles.isEmpty()) {
            throw new RuntimeException("Unable to migrate: no Java files found in " + dir);
        }
        List<Path> list = javaFiles;
        if (list == null) {
            LightTestMigration.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static void enqueue(LightTestMigration migration, String testName) {
        if (ourPrevious == null || !LightTestMigration.ourPrevious.myTestClass.equals(migration.myTestClass)) {
            LightTestMigration.flush();
            ourPrevious = migration;
        }
        LightTestMigration.ourPrevious.myTestNames.add(testName);
    }

    private static void flush() {
        if (ourPrevious != null) {
            ourPrevious.generateClassTemplate();
            ourPrevious = null;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(LightTestMigration::flush, "LightTestMigration flusher"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightTestMigration", "getJavaFiles"));
    }
}

