/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.utils.pathVariables;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.parameters.PathVariableDefinitionsSearcher;
import com.intellij.microservices.url.parameters.PathVariablePsiElement;
import com.intellij.microservices.url.parameters.PathVariableSem;
import com.intellij.microservices.url.parameters.PathVariableUtils;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Plow;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathVariableSemJamBase
implements PathVariableSem {
    private final FrameworkUrlPathSpecification specification;
    private final PathVariableDefinitionsSearcher myDefinitionsSearcher;
    private final JamMemberMeta<PsiParameter, ? extends PathVariableSem> myMeta;

    public PathVariableSemJamBase(FrameworkUrlPathSpecification specification, PathVariableDefinitionsSearcher definitionsSearcher, JamMemberMeta<PsiParameter, ? extends PathVariableSem> myMeta) {
        this.specification = specification;
        this.myDefinitionsSearcher = definitionsSearcher;
        this.myMeta = myMeta;
    }

    @Nullable
    public PathVariablePsiElement getPathVariablePsiElement() {
        if (!this.isActualNameHolder()) {
            return null;
        }
        String name = this.getName();
        return PathVariablePsiElement.merge((List)this.myDefinitionsSearcher.getPathVariables((PsiElement)this.getPsiElement()).filter(e -> e.getName().equals(name)).toList());
    }

    protected abstract PsiParameter getPsiElement();

    @NotNull
    public Plow<LookupElement> getNameVariants() {
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.getPsiElement(), PsiMethod.class);
        if (psiMethod == null) {
            Plow plow = Plow.empty();
            if (plow == null) {
                PathVariableSemJamBase.$$$reportNull$$$0(0);
            }
            return plow;
        }
        UrlPathContext urlPathContext = this.specification.getUrlPathContext((PsiElement)psiMethod);
        Set consumedNames = StreamEx.of((Object[])psiMethod.getParameterList().getParameters()).map(arg_0 -> this.myMeta.getJamElement(arg_0)).nonNull().map(PathVariableSem::getName).toSet();
        Plow plow = Plow.ofIterable((Iterable)PathVariableUtils.getPathVariablesFromContext((UrlPathContext)urlPathContext)).filter(name -> !consumedNames.contains(name)).map(name -> LookupElementBuilder.create((String)name).withIcon(PlatformIcons.VARIABLE_ICON).withTypeText(MicroservicesBundle.message((String)"microservices.url.path.variable.typeName", (Object[])new Object[0])));
        if (plow == null) {
            PathVariableSemJamBase.$$$reportNull$$$0(1);
        }
        return plow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/microservices/utils/pathVariables/PathVariableSemJamBase", "getNameVariants"));
    }

    public static class DelegationHelper
    extends PathVariableSemJamBase {
        private final PathVariableSem myParent;
        private final Supplier<? extends PsiParameter> myPsiParameterSupplier;

        public DelegationHelper(FrameworkUrlPathSpecification specification, PathVariableDefinitionsSearcher definitionsSearcher, JamMemberMeta<PsiParameter, ? extends PathVariableSem> META, PathVariableSem parent, Supplier<? extends PsiParameter> supplier) {
            super(specification, definitionsSearcher, META);
            this.myParent = parent;
            this.myPsiParameterSupplier = supplier;
        }

        @NotNull
        public String getName() {
            String string = this.myParent.getName();
            if (string == null) {
                DelegationHelper.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isActualNameHolder() {
            return this.myParent.isActualNameHolder();
        }

        @Override
        protected PsiParameter getPsiElement() {
            return this.myPsiParameterSupplier.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/microservices/utils/pathVariables/PathVariableSemJamBase$DelegationHelper", "getName"));
        }
    }
}

