/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.utils.pathVariables;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.actions.ParametersKt;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uast.UastSmartPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/microservices/utils/pathVariables/PathVariableQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "method", "Lorg/jetbrains/uast/UMethod;", "pathVariableName", "", "pathVariableAnnotationFQN", "(Lorg/jetbrains/uast/UMethod;Ljava/lang/String;Ljava/lang/String;)V", "methodPointer", "Lcom/intellij/uast/UastSmartPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "makeExpectedPathVariableParameter", "", "Lcom/intellij/lang/jvm/actions/ExpectedParameter;", "name", "context", "Lcom/intellij/psi/PsiElement;", "intellij.microservices.uast"})
final class PathVariableQuickFix
implements LocalQuickFix {
    private final UastSmartPointer<UMethod> methodPointer;
    private final String pathVariableName;
    private final String pathVariableAnnotationFQN;

    @NotNull
    public String getName() {
        return MicroservicesBundle.message((String)"PathVariableInspection.quick.fix.create.param.name", (Object[])new Object[]{this.pathVariableName});
    }

    @NotNull
    public String getFamilyName() {
        return MicroservicesBundle.message((String)"PathVariableInspection.quick.fix.create.param", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        List<ExpectedParameter> paramsToAdd = this.makeExpectedPathVariableParameter(this.pathVariableName, element);
        UMethod uMethod = (UMethod)this.methodPointer.getElement();
        if (uMethod == null || (uMethod = uMethod.getJavaPsi()) == null) {
            return;
        }
        UMethod method = uMethod;
        IntentionAction intentionAction = (IntentionAction)CollectionsKt.firstOrNull((List)JvmElementActionFactories.createChangeParametersActions((JvmMethod)((JvmMethod)method), (ChangeParametersRequest)MethodRequestsKt.updateMethodParametersRequest((Supplier)new Supplier<JvmMethod>((PsiMethod)method){
            final /* synthetic */ PsiMethod $method;

            @Nullable
            public final JvmMethod get() {
                return (JvmMethod)this.$method;
            }
            {
                this.$method = psiMethod;
            }
        }, (Function)new Function<List<? extends ExpectedParameter>, List<? extends ExpectedParameter>>(paramsToAdd){
            final /* synthetic */ List $paramsToAdd;

            @NotNull
            public final List<ExpectedParameter> apply(@NotNull List<? extends ExpectedParameter> existing) {
                Intrinsics.checkNotNullParameter(existing, (String)"existing");
                return ContainerUtil.concat(existing, (List)this.$paramsToAdd);
            }
            {
                this.$paramsToAdd = list;
            }
        })));
        if (intentionAction == null) {
            return;
        }
        IntentionAction methodsFix2 = intentionAction;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(methodsFix2, project, descriptor){
            final /* synthetic */ IntentionAction $methodsFix$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ ProblemDescriptor $descriptor$inlined;
            {
                this.$methodsFix$inlined = intentionAction;
                this.$project$inlined = project;
                this.$descriptor$inlined = problemDescriptor;
            }

            public final T compute() {
                boolean bl = false;
                PsiElement psiElement = this.$descriptor$inlined.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"descriptor.psiElement");
                this.$methodsFix$inlined.invoke(this.$project$inlined, null, psiElement.getContainingFile());
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final List<ExpectedParameter> makeExpectedPathVariableParameter(String name, PsiElement context) {
        AnnotationAttributeRequest[] annotationAttributeRequestArray;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        Project project2 = project;
        boolean isValidIdentifier = PsiNameHelper.getInstance((Project)project2).isIdentifier(name, LanguageLevel.HIGHEST);
        PsiClassType psiClassType = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project2), (GlobalSearchScope)context.getResolveScope());
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"PsiType.getJavaLangStrin\u2026t), context.resolveScope)");
        JvmType jvmType = (JvmType)psiClassType;
        String string = isValidIdentifier ? name : "parameter";
        if (isValidIdentifier) {
            annotationAttributeRequestArray = new AnnotationAttributeRequest[]{};
        } else {
            AnnotationAttributeRequest[] annotationAttributeRequestArray2 = new AnnotationAttributeRequest[1];
            annotationAttributeRequestArray = annotationAttributeRequestArray2;
            annotationAttributeRequestArray2[0] = AnnotationAttributeValueRequestKt.stringAttribute((String)"value", (String)name);
        }
        return CollectionsKt.listOf((Object)ParametersKt.expectedParameter((JvmType)jvmType, (String)string, (Collection)CollectionsKt.listOf((Object)AnnotationRequestsKt.annotationRequest((String)this.pathVariableAnnotationFQN, (AnnotationAttributeRequest[])Arrays.copyOf(annotationAttributeRequestArray, annotationAttributeRequestArray.length)))));
    }

    public PathVariableQuickFix(@NotNull UMethod method, @NotNull String pathVariableName, @NotNull String pathVariableAnnotationFQN) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pathVariableName, (String)"pathVariableName");
        Intrinsics.checkNotNullParameter((Object)pathVariableAnnotationFQN, (String)"pathVariableAnnotationFQN");
        this.pathVariableName = pathVariableName;
        this.pathVariableAnnotationFQN = pathVariableAnnotationFQN;
        UElement $this$createUastSmartPointer$iv = (UElement)method;
        boolean $i$f$createUastSmartPointer = false;
        this.methodPointer = new UastSmartPointer($this$createUastSmartPointer$iv, UMethod.class);
    }
}

