/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.uast.url;

import com.intellij.lang.Language;
import com.intellij.microservices.uast.url.UastUrlPathInlayLanguagesProvider;
import com.intellij.microservices.url.inlay.UrlPathInlayLanguagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastMetaLanguage;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/microservices/uast/url/UastUrlPathInlayLanguagesProvider;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayLanguagesProvider;", "()V", "languages", "", "Lcom/intellij/lang/Language;", "getLanguages", "()Ljava/util/Collection;", "getPotentialElementsWithHintsProviders", "", "Lcom/intellij/psi/PsiElement;", "element", "Companion", "intellij.microservices.uast"})
public final class UastUrlPathInlayLanguagesProvider
implements UrlPathInlayLanguagesProvider {
    private static final int PARENT_SEARCH_LIMIT = 3;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Collection<Language> getLanguages() {
        Language language = Language.findInstance(UastMetaLanguage.class);
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"Language.findInstance(Ua\u2026MetaLanguage::class.java)");
        Collection collection = ((UastMetaLanguage)language).getMatchingLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"Language.findInstance(Ua\u2026s.java).matchingLanguages");
        return collection;
    }

    @NotNull
    public List<PsiElement> getPotentialElementsWithHintsProviders(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UElement uDeclaration = UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UClass.class, UMethod.class});
        if (uDeclaration != null) {
            if (Intrinsics.areEqual((Object)((UDeclaration)uDeclaration).getSourcePsi(), (Object)element) ^ true) {
                return CollectionsKt.emptyList();
            }
            PsiElement javaPsiElement = ((UDeclaration)uDeclaration).getJavaPsi();
            if (Intrinsics.areEqual((Object)element, (Object)javaPsiElement)) {
                return CollectionsKt.listOf((Object)element);
            }
            return CollectionsKt.listOfNotNull((Object[])new PsiElement[]{element, javaPsiElement});
        }
        PsiElement $this$toUElementOfType$iv = element;
        boolean $i$f$toUElementOfType = false;
        UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
        if (uExpression == null) {
            return CollectionsKt.emptyList();
        }
        UExpression uExpression2 = uExpression;
        if (SequencesKt.any((Sequence)SequencesKt.filter((Sequence)SequencesKt.take((Sequence)UElementKt.getWithContainingElements((UElement)((UElement)uExpression2)), (int)3), (Function1)getPotentialElementsWithHintsProviders.1.INSTANCE))) {
            return CollectionsKt.listOf((Object)element);
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/microservices/uast/url/UastUrlPathInlayLanguagesProvider$Companion;", "", "()V", "PARENT_SEARCH_LIMIT", "", "intellij.microservices.uast"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

