/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.mime;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.mime.MimeTypeReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH$\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/mime/IncorrectMimeTypeReferenceInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getPattern", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UExpression;", "intellij.microservices.uast"})
public abstract class IncorrectMimeTypeReferenceInspection
extends LocalInspectionTool {
    @NotNull
    protected abstract ElementPattern<? extends UExpression> getPattern();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        ElementPattern<? extends UExpression> elementPattern = this.getPattern();
        return new PsiElementVisitor(elementPattern, holder){
            final /* synthetic */ ElementPattern $elementPattern;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)element, UInjectionHost.class);
                if (uInjectionHost == null) {
                    return;
                }
                UInjectionHost expression = uInjectionHost;
                if (expression.getUastParent() instanceof UPolyadicExpression) {
                    return;
                }
                if (this.$elementPattern.accepts((Object)expression)) {
                    for (PsiReference reference : element.getReferences()) {
                        TextRange range;
                        if (!(reference instanceof MimeTypeReference) || reference.resolve() != null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)reference.getRangeInElement(), (String)"reference.getRangeInElement()");
                        if (range.isEmpty() && range.getStartOffset() == 1 && Intrinsics.areEqual((Object)"\"\"", (Object)element.getText())) {
                            String message;
                            Intrinsics.checkNotNullExpressionValue((Object)ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), (String)"ProblemsHolder.unresolve\u2026ferenceMessage(reference)");
                            this.$holder.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
                            continue;
                        }
                        this.$holder.registerProblem(reference);
                    }
                }
            }
            {
                this.$elementPattern = $captured_local_variable$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }
}

