/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.utils;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.DiagramJavaBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlJavaUtils {
    @Nullable
    public static String getPackageName(PsiElement element) {
        if (element instanceof PsiClass) {
            return (String)ReadAction.compute(() -> ((PsiClassOwner)element.getContainingFile()).getPackageName());
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static String getRealPackageName(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            PsiClass aClass = (PsiClass)psiElement;
            while (aClass.getContainingClass() != null) {
                PsiClass c = aClass.getContainingClass();
                if (c == null) {
                    return UmlJavaUtils.getPackageName((PsiElement)c);
                }
                aClass = c;
            }
            return UmlJavaUtils.getPackageName((PsiElement)aClass);
        }
        return UmlJavaUtils.getPackageName(psiElement);
    }

    @Nullable
    public static PsiPackage getPackage(PsiElement element) {
        String fqn = UmlJavaUtils.getRealPackageName(element);
        return fqn == null ? null : JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(fqn);
    }

    public static PackageInfo getInfo(PsiPackage p) {
        return new PackageInfo(p);
    }

    public static boolean prepareClassForWrite(PsiClass psiClass) {
        boolean prepared = CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])new PsiElement[]{psiClass});
        if (!prepared) {
            Messages.showErrorDialog((Project)psiClass.getProject(), (String)DiagramBundle.message((String)"class.is.readonly", (Object[])new Object[]{psiClass.getName()}), (String)DiagramBundle.message((String)"error", (Object[])new Object[0]));
        }
        return prepared;
    }

    @Nullable
    public static String getFQN(@NotNull PsiElement element) {
        if (element == null) {
            UmlJavaUtils.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uml/utils/UmlJavaUtils", "getFQN"));
    }

    public static final class PackageInfo {
        private int totalClassesCount = 0;
        private int totalSubpackagesCount = 0;
        private int classesCount = 0;
        private int subpackagesCount = 0;
        private final String fqn;

        private PackageInfo(PsiPackage p) {
            this.fqn = p.getQualifiedName();
            this.classesCount = p.getClasses().length;
            this.subpackagesCount = p.getSubPackages().length;
            this.traverse(p);
        }

        private void traverse(PsiPackage p) {
            this.totalClassesCount += p.getClasses().length;
            this.totalSubpackagesCount += p.getSubPackages().length;
            for (PsiPackage aPackage : p.getSubPackages()) {
                this.traverse(aPackage);
            }
        }

        @Nls
        public String toString() {
            return DiagramJavaBundle.message("package.info.message", this.fqn, this.classesCount, this.classesCount, this.subpackagesCount, this.subpackagesCount, this.totalClassesCount, this.totalClassesCount, this.totalSubpackagesCount, this.totalSubpackagesCount);
        }
    }
}

