/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.ModulesUmlEdge;
import com.intellij.uml.project.ModulesUmlNode;
import com.intellij.uml.project.ModulesUmlRelationships;
import com.intellij.util.Chunk;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class UmlModulesRelationshipHelper {
    private UmlModulesRelationshipHelper() {
    }

    public static List<ModulesUmlEdge> generateEdges(@NotNull Map<ModuleItem, ModulesUmlNode> nodes, Project project, boolean includeTestDependencies) {
        if (nodes == null) {
            UmlModulesRelationshipHelper.$$$reportNull$$$0(0);
        }
        ArrayList<ModulesUmlEdge> edges = new ArrayList<ModulesUmlEdge>();
        HashMap<Module, ModulesUmlNode> modulesNodes = new HashMap<Module, ModulesUmlNode>();
        HashMap<Library, ModulesUmlNode> libraryNodes = new HashMap<Library, ModulesUmlNode>();
        for (ModuleItem moduleItem : nodes.keySet()) {
            if (moduleItem.isLibrary()) {
                libraryNodes.put(moduleItem.getLibrary(), nodes.get(moduleItem));
                continue;
            }
            if (!moduleItem.isModule()) continue;
            modulesNodes.put(moduleItem.getModule(), nodes.get(moduleItem));
        }
        MultiMap moduleEdges = new MultiMap();
        for (Module module : modulesNodes.keySet()) {
            ModulesUmlNode from = (ModulesUmlNode)((Object)modulesNodes.get(module));
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutModuleSourceEntries();
            if (!includeTestDependencies) {
                enumerator = enumerator.productionOnly();
            }
            enumerator.forEachModule(dep -> {
                ModulesUmlNode to = (ModulesUmlNode)((Object)((Object)((Object)modulesNodes.get(dep))));
                if (to != null) {
                    moduleEdges.putValue((Object)module, dep);
                }
                return true;
            });
            enumerator.forEachLibrary(library -> {
                ModulesUmlNode to = (ModulesUmlNode)((Object)((Object)((Object)libraryNodes.get(library))));
                if (to != null) {
                    edges.add(new ModulesUmlEdge((DiagramNode<ModuleItem>)from, (DiagramNode<ModuleItem>)to, ModulesUmlRelationships.LIB));
                }
                return true;
            });
        }
        GraphAlgorithms graphAlgorithms = GraphAlgorithms.getInstance();
        Graph graph = graphAlgorithms.computeSCCGraph(ModuleManager.getInstance((Project)project).moduleGraph(includeTestDependencies));
        HashMap<Module, Chunk> module2Chunk = new HashMap<Module, Chunk>();
        for (Chunk chunk : graph.getNodes()) {
            for (Module module : chunk.getNodes()) {
                module2Chunk.put(module, chunk);
            }
        }
        for (Module from : moduleEdges.keySet()) {
            for (Module to : moduleEdges.get((Object)from)) {
                boolean cyclic = ((Chunk)module2Chunk.get(from)).equals(module2Chunk.get(to));
                DiagramRelationshipInfo relationship = cyclic ? ModulesUmlRelationships.CIRCLE_DEPENDENCY : ModulesUmlRelationships.MODULE;
                edges.add(new ModulesUmlEdge((DiagramNode<ModuleItem>)((DiagramNode)modulesNodes.get(from)), (DiagramNode<ModuleItem>)((DiagramNode)modulesNodes.get(to)), relationship));
            }
        }
        return edges;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/uml/project/UmlModulesRelationshipHelper", "generateEdges"));
    }
}

