/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.presentation;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.EditEdgeHandler;
import com.intellij.diagram.extras.EditNodeHandler;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.Drawable;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.uml.core.actions.DeleteNodeContentAction;
import com.intellij.uml.core.actions.DeleteSelectionWrapper;
import com.intellij.uml.core.actions.UmlActions;
import com.intellij.uml.core.actions.UmlNewAction;
import com.intellij.uml.core.actions.UmlShowDependencies;
import com.intellij.uml.core.actions.popup.AddElementsFromPopupAction;
import com.intellij.uml.core.actions.scopes.UmlScopesActionGroup;
import com.intellij.uml.core.actions.visibility.UmlVisibilityActionGroup;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.editors.DiagramNodeCellEditor;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Alarm;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.messages.MessageBusListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramPresentationModelImpl
extends DiagramPresentationModel {
    private final Project project;
    protected DefaultUmlRenderer myRenderer;
    private long modificationCounter = 0L;
    private final DiagramState myPresentation;
    private final DiagramProvider myProvider;
    private final DefaultActionGroup elementProvidersActions = new DefaultActionGroup();
    private final DefaultActionGroup extraActions = new DefaultActionGroup();
    private final Alarm myAlarm = new Alarm((Disposable)this);
    private final UmlNodeHighlighter nodeHighlighter;
    private static final Color ARROW_BG = Gray.TRANSPARENT;
    private static final Map<Shape, Arrow> KNOWN_SHAPES = new HashMap<Shape, Arrow>();

    public DiagramPresentationModelImpl(Graph2D graph, Project project, DiagramProvider provider) {
        super(graph);
        this.myPresentation = new DiagramState(provider);
        this.project = project;
        this.myProvider = provider;
        this.setShowEdgeLabels(true);
        DiagramExtras extras = provider.getExtras();
        this.nodeHighlighter = extras.getNodeHighlighter();
        MessageBusListener listener = provider.getMessageBusListener(project, graph);
        if (listener != null) {
            project.getMessageBus().connect((Disposable)this).subscribe(listener.getTopic(), listener.getListener());
        }
        this.customizeDefaultSettings();
    }

    @NotNull
    public DiagramBuilder getDiagramBuilder() {
        DiagramBuilder diagramBuilder = (DiagramBuilder)super.getGraphBuilder();
        if (diagramBuilder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(0);
        }
        return diagramBuilder;
    }

    private void customizeDefaultSettings() {
        DiagramExtras extras = this.myProvider.getExtras();
        if (extras.useDefaultLayouter()) {
            return;
        }
        Layouter layouter = extras.getCustomLayouter(this.getSettings(), this.project);
        if (layouter == null) {
            layouter = Utils.getLayouter((GraphSettings)this.getSettings(), (DiagramLayout)this.myPresentation.getLayout());
        }
        this.getSettings().setCurrentLayouter(layouter);
        this.getSettings().setFitContentAfterLayout(this.myPresentation.isFitContentAfterLayout());
    }

    @NotNull
    public NodeRealizer getNodeRealizer(DiagramNode node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"UmlNodeInfoRenderer", (NodeCellRenderer)this.getRenderer());
        if (nodeRealizer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(1);
        }
        return nodeRealizer;
    }

    public DefaultUmlRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new DefaultUmlRenderer(this.getBuilder(), this.createModificationTracker());
        }
        return this.myRenderer;
    }

    @NotNull
    protected ModificationTracker createModificationTracker() {
        return new ModificationTracker(){
            final ModificationTracker modificationTracker;
            long myCount;
            {
                this.modificationTracker = DiagramPresentationModelImpl.this.getBuilder().getDataModel().getModificationTracker();
                this.myCount = this.modificationTracker.getModificationCount();
            }

            public long getModificationCount() {
                long count = this.modificationTracker.getModificationCount();
                if (this.myCount != count) {
                    this.myCount = count;
                    DiagramPresentationModelImpl.this.myAlarm.cancelAllRequests();
                    if (!DiagramPresentationModelImpl.this.myAlarm.isDisposed()) {
                        DiagramPresentationModelImpl.this.myAlarm.addRequest(() -> {
                            DiagramPresentationModelImpl.this.getBuilder().getDataModel().refreshDataModel();
                            DiagramPresentationModelImpl.this.update();
                            if (DiagramNodeEditorManager.getInstance().getCurrentCellEditor() != null) {
                                DiagramNodeEditorManager.getInstance().stopEditing(DiagramPresentationModelImpl.this.getBuilder());
                            }
                        }, 300);
                    }
                }
                return count + DiagramPresentationModelImpl.this.modificationCounter;
            }
        };
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(DiagramEdge edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        if (edge != null) {
            if (!(edge instanceof DiagramNoteEdge)) {
                edgeRealizer.setLineColor(this.myProvider.getColorManager().getEdgeColor(this.getBuilder(), edge));
            } else {
                edgeRealizer.setLineColor(ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.4));
            }
            DiagramRelationshipInfo info = edge.getRelationship();
            DiagramLineType lineType = info.getLineType();
            edgeRealizer.setLineType(DiagramPresentationModelImpl.toGraphLineType(info.getWidth(), lineType != null ? lineType : DiagramLineType.SOLID));
            edgeRealizer.setArrow(DiagramPresentationModelImpl.getArrow(info.getStartArrow()));
            edgeRealizer.setSourceArrow(DiagramPresentationModelImpl.getArrow(info.getEndArrow()));
        }
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(2);
        }
        return polyLineEdgeRealizer;
    }

    @Nullable
    private EdgeLabel createEdge(String label, byte model, byte position, Color color) {
        if (StringUtil.isEmpty((String)label)) {
            return null;
        }
        EdgeLabel edgeLabel = GraphManager.getGraphManager().createEdgeLabel(label);
        edgeLabel.setModel(model);
        edgeLabel.setPosition(position);
        edgeLabel.setTextColor(color == null ? this.getBuilder().getColorScheme().getDefaultForeground() : color);
        return edgeLabel;
    }

    public EdgeLabel[] getEdgeLabels(DiagramEdge umlEdge, String edgeName) {
        if (!this.isShowEdgeLabels() || umlEdge == null) {
            return EMPTY_LABELS;
        }
        DiagramRelationshipInfo relationship = umlEdge.getRelationship();
        ArrayList<EdgeLabel> labels = new ArrayList<EdgeLabel>();
        EdgeLabel center = this.createEdge(relationship.getLabel(), EdgeLabel.CENTERED, EdgeLabel.CENTER, relationship.getLabelColor());
        EdgeLabel from = this.createEdge(relationship.getFromLabel(), EdgeLabel.SIX_POS, EdgeLabel.SHEAD, relationship.getFromLabelColor());
        EdgeLabel to = this.createEdge(relationship.getToLabel(), EdgeLabel.SIX_POS, EdgeLabel.THEAD, relationship.getToLabelColor());
        if (center != null) {
            labels.add(center);
        }
        if (from != null) {
            labels.add(from);
        }
        if (to != null) {
            labels.add(to);
        }
        return labels.isEmpty() ? EMPTY_LABELS : labels.toArray(new EdgeLabel[0]);
    }

    public boolean editNode(DiagramNode node) {
        DiagramBuilder builder = this.getBuilder();
        if (node instanceof DiagramNoteNode) {
            DiagramNoteNode note = (DiagramNoteNode)node;
            String text = Messages.showMultilineInputDialog((Project)this.project, (String)DiagramBundle.message((String)"dialog.message.note.text", (Object[])new Object[0]), (String)DiagramBundle.message((String)"dialog.title.edit.note", (Object[])new Object[0]), (String)note.getTooltip(), (Icon)Messages.getQuestionIcon(), (InputValidator)new NonEmptyInputValidator());
            if (text != null && !text.equals(note.getTooltip())) {
                Runnable editNote = () -> {
                    Node n = builder.getNode((DiagramNode)note);
                    NodeRealizer realizer = builder.getGraph().getRealizer(n);
                    double x = realizer.getX();
                    double y = realizer.getY();
                    DiagramNode originalNode = note.getIdentifyingElement();
                    DiagramDataModel dataModel = builder.getDataModel();
                    dataModel.removeNote(note);
                    builder.updateGraph();
                    dataModel.addNote(originalNode, text);
                    builder.updateGraph();
                    NodeRealizer noteRealizer = builder.getGraph().getRealizer(builder.getNode((DiagramNode)dataModel.getNotes().get(originalNode)));
                    noteRealizer.setX(x);
                    noteRealizer.setY(y);
                    builder.updateGraph();
                };
                DiagramAction.performCommand((DiagramBuilder)builder, (Runnable)editNote, (String)DiagramBundle.message((String)"command.edit.note", (Object[])new Object[0]), null, (PsiElement[])new PsiElement[0]);
            }
            return true;
        }
        if (node == null) {
            return false;
        }
        DiagramExtras extras = node.getProvider().getExtras();
        EditNodeHandler editHandler = extras.getEditNodeHandler();
        if (editHandler != null) {
            editHandler.doEdit(node, (DiagramPresentationModel)this);
            return true;
        }
        if (this.getBuilder().isPopupMode()) {
            Object element = node.getIdentifyingElement();
            if (element instanceof Navigatable) {
                OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{(Navigatable)element});
                return true;
            }
        } else {
            Node nodeObj = builder.getNode(node);
            return DiagramUtils.isNodeWithoutBody((DiagramBuilder)builder, (Node)nodeObj);
        }
        return super.editNode((Object)node);
    }

    public boolean editEdge(DiagramEdge edge) {
        EditEdgeHandler handler = this.getBuilder().getProvider().getExtras().getEditEdgeHandler();
        DiagramNode src = edge.getSource();
        DiagramNode trg = edge.getTarget();
        if (handler != null && !(src instanceof DiagramNoteNode) && !(trg instanceof DiagramNoteNode) && handler.doEdit(edge, (DiagramPresentationModel)this)) {
            return true;
        }
        Object element = edge.getIdentifyingElement();
        if (element instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)element});
            return true;
        }
        return super.editEdge((Object)edge);
    }

    public String getNodeTooltip(DiagramNode node) {
        if (node instanceof DiagramNoteNode) {
            return "Note for " + ((DiagramNode)node.getIdentifyingElement()).getTooltip();
        }
        return this.myProvider.getElementManager().getNodeTooltip(node.getIdentifyingElement());
    }

    public String getEdgeTooltip(DiagramEdge edge) {
        return edge.getName();
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        super.customizeSettings(view, editMode);
        view.setAntialiasedPainting(true);
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        editMode.allowNodeEditing(true);
        UmlActions.registerCustomShortcuts(this.getBuilder());
        UmlActions.install(this.getBuilder());
        for (DiagramNodeIntentionAction action : this.getBuilder().getProvider().getNodeIntentionActions()) {
            ShortcutSet shortcut;
            if (!(action instanceof ShortcutProvider) || (shortcut = ((ShortcutProvider)action).getShortcut()) == null) continue;
            action.registerCustomShortcutSet(shortcut, this.getBuilder().getView().getCanvasComponent(), (Disposable)this.getBuilder());
        }
        view.setFitContentOnResize(false);
        view.setGridVisible(false);
    }

    public DiagramState getPresentation() {
        return this.myPresentation;
    }

    public EdgeCreationPolicy<DiagramNode> getEdgeCreationPolicy() {
        final DiagramEdgeCreationPolicy policy = this.myProvider.getEdgeCreationPolicy();
        return policy == null ? EdgeCreationPolicy.NO_POLICY : new EdgeCreationPolicy<DiagramNode>(){

            public boolean acceptSource(@NotNull DiagramNode source) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                return policy.acceptSource(source);
            }

            public boolean acceptTarget(@NotNull DiagramNode target) {
                if (target == null) {
                    2.$$$reportNull$$$0(1);
                }
                return policy.acceptTarget(target);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/uml/presentation/DiagramPresentationModelImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptTarget";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public NodeCellEditor getCustomNodeCellEditor(DiagramNode umlNode) {
        return new DiagramNodeCellEditor(this.getBuilder());
    }

    public DefaultActionGroup getNodeActionGroup(DiagramNode info) {
        return this.getCommonActionGroup();
    }

    protected DefaultActionGroup getCommonActionGroup() {
        DiagramExtras extras;
        DiagramAddElementAction handler;
        DiagramScopeManager scopeManager;
        UmlVisibilityActionGroup visibility;
        DefaultActionGroup categories;
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new ActionGroup(DiagramBundle.message((String)"group.action.text.new", (Object[])new Object[0]), true){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                if (e == null) {
                    if (EMPTY_ARRAY == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return EMPTY_ARRAY;
                }
                AnAction[] anActionArray = new UmlNewAction().getGroup(e.getDataContext()).getChildren(e);
                if (anActionArray == null) {
                    3.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/presentation/DiagramPresentationModelImpl$3", "getChildren"));
            }
        });
        if (this.allowChangeVisibleCategories() && (categories = UmlActions.getCategoriesActions(this.getBuilder())).getChildrenCount() > 0) {
            actions.add((AnAction)categories);
        }
        if ((visibility = new UmlVisibilityActionGroup(this.getBuilder())).getChildrenCount() > 0) {
            actions.add((AnAction)visibility);
        }
        if ((scopeManager = this.getBuilder().getDataModel().getScopeManager()) != null) {
            UmlScopesActionGroup actionGroup = new UmlScopesActionGroup(this.getBuilder(), scopeManager);
            actions.add((AnAction)actionGroup);
        }
        if ((handler = (extras = this.getBuilder().getProvider().getExtras()).getAddElementHandler()) != null) {
            actions.add((AnAction)handler);
        }
        actions.addSeparator();
        if (this.elementProvidersActions.getChildrenCount() > 0) {
            actions.addAll((ActionGroup)this.elementProvidersActions);
            actions.addSeparator();
        }
        if (this.extraActions.getChildrenCount() > 0) {
            actions.addAll((ActionGroup)this.extraActions);
            actions.addSeparator();
        }
        if (extras.isExpandCollapseActionsImplemented()) {
            actions.add(ActionManager.getInstance().getAction("Uml.CollapseNodes"));
            actions.add(ActionManager.getInstance().getAction("Uml.ExpandNodes"));
            actions.addSeparator();
        }
        if (this.getBuilder().getDataModel().isDependencyDiagramSupported()) {
            actions.add((AnAction)new UmlShowDependencies());
            actions.addSeparator();
        }
        if (extras.isDeleteActionImplemented()) {
            actions.add((AnAction)new DeleteSelectionWrapper.DeleteSelectedItemDiagramAction());
            actions.addSeparator();
        }
        if (extras.isSourceActionsImplemented()) {
            actions.add(ActionManager.getInstance().getAction("UML.SourceActionsGroup"));
            actions.addSeparator();
        }
        actions.add(ActionManager.getInstance().getAction("UML.DefaultGraphPopup"));
        return actions;
    }

    private void registerElementProvidersActions() {
        DiagramExtras extras = this.myProvider.getExtras();
        DiagramElementsProvider[] providers = extras.getElementsProviders();
        if (providers != null) {
            for (DiagramElementsProvider provider : providers) {
                AddElementsFromPopupAction addElementsFromPopupAction = new AddElementsFromPopupAction(provider, this.getBuilder());
                this.elementProvidersActions.add((AnAction)addElementsFromPopupAction);
            }
        }
    }

    private void registerExtraActions() {
        DiagramExtras extras = this.myProvider.getExtras();
        for (AnAction action : extras.getExtraActions()) {
            this.extraActions.add(action);
        }
    }

    public void registerActions() {
        this.registerElementProvidersActions();
        this.registerExtraActions();
        new DeleteNodeContentAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), this.getBuilder().getView().getCanvasComponent());
    }

    public void update() {
        ++this.modificationCounter;
        this.getBuilder().update(false, false);
    }

    public boolean isAutoRotateLabels() {
        return true;
    }

    private static LineType toGraphLineType(int width, DiagramLineType type) {
        switch (type) {
            case SOLID: {
                return LineType.Statics.getLineType((int)width, (byte)LineType.LINE_1.getLineStyle());
            }
            case DASHED: {
                return LineType.Statics.getLineType((int)width, (byte)LineType.DASHED_1.getLineStyle());
            }
            case DOTTED: {
                return LineType.Statics.getLineType((int)width, (byte)LineType.DOTTED_2.getLineStyle());
            }
        }
        return LineType.Statics.getLineType((int)width, (byte)LineType.LINE_1.getLineStyle());
    }

    private static Arrow getInnerArrow() {
        String INNER_CLASS_ARROW = "InnerClassArrow";
        if (Arrow.Statics.getCustomArrow((String)"InnerClassArrow") == null) {
            int R = 5;
            Drawable arrow = new Drawable(){

                public void paint(Graphics2D g) {
                    Paint paint = g.getPaint();
                    g.setPaint(g.getBackground());
                    g.fillOval(-10, -5, 10, 10);
                    g.setPaint(paint);
                    g.drawOval(-10, -5, 10, 10);
                    g.drawLine(-5, -3, -5, 3);
                    g.drawLine(-8, 0, -2, 0);
                }

                public Rectangle getBounds() {
                    return new Rectangle(-5, -5, 5, 5);
                }
            };
            Arrow.Statics.addCustomArrow((String)"InnerClassArrow", (Drawable)arrow);
        }
        return Arrow.Statics.getCustomArrow((String)"InnerClassArrow");
    }

    private static Arrow getDeltaSmallArrow() {
        String DELTA_SMALL_ARROW = "DeltaSmallArrow";
        if (Arrow.Statics.getCustomArrow((String)"DeltaSmallArrow") == null) {
            Drawable arrow = new Drawable(){
                int R = 3;
                int[] X = new int[]{-2 * this.R + 1, 1, -2 * this.R + 1};
                int[] Y = new int[]{-this.R, 0, this.R};

                public void paint(Graphics2D g) {
                    g.fillPolygon(this.X, this.Y, 3);
                }

                public Rectangle getBounds() {
                    return new Rectangle(0, 0, 2 * this.R, 2 * this.R);
                }
            };
            Arrow.Statics.addCustomArrow((String)"DeltaSmallArrow", (Drawable)arrow);
        }
        return Arrow.Statics.getCustomArrow((String)"DeltaSmallArrow");
    }

    private static Arrow getArrow(Shape shape) {
        if (shape == null) {
            return Arrow.NONE;
        }
        Arrow arrow = KNOWN_SHAPES.get(shape);
        if (arrow != null) {
            return arrow;
        }
        String id = "UML_" + shape.hashCode();
        arrow = Arrow.Statics.getCustomArrow((String)id);
        return arrow == null ? Arrow.Statics.addCustomArrow((String)id, (Shape)shape, (Color)ARROW_BG) : arrow;
    }

    public void onSelectionChanged(Graph2DSelectionEvent e) {
        this.dropHighlightingFlag();
        if (this.nodeHighlighter != null) {
            List list;
            this.nodeHighlighter.selectionChanged(this.getBuilder());
            ArrayList nodes = DiagramUtils.getSelectedNodes((DiagramBuilder)this.getBuilder());
            for (DiagramNode node : new ArrayList(nodes)) {
                if (!(node instanceof DiagramNoteNode)) continue;
                nodes.remove(node);
            }
            if (!nodes.isEmpty() && (list = this.nodeHighlighter.onNodeSelected((List)nodes, this.getBuilder().getDataModel())) != null && !list.isEmpty()) {
                for (DiagramNode umlNode : this.getBuilder().getNodeObjects()) {
                    umlNode.putUserData(DiagramNode.SELECTED_NODE_KEY, (Object)list.contains(umlNode));
                }
            }
        }
    }

    private void dropHighlightingFlag() {
        for (DiagramNode node : this.getBuilder().getNodeObjects()) {
            node.putUserData(DiagramNode.SELECTED_NODE_KEY, null);
        }
    }

    public DiagramBuilder getBuilder() {
        return (DiagramBuilder)this.getGraphBuilder();
    }

    static {
        KNOWN_SHAPES.put(DiagramRelationshipInfo.NONE, Arrow.NONE);
        KNOWN_SHAPES.put(DiagramRelationshipInfo.DIAMOND, Arrow.DIAMOND);
        KNOWN_SHAPES.put(DiagramRelationshipInfo.DELTA, Arrow.DELTA);
        KNOWN_SHAPES.put(DiagramRelationshipInfo.STANDARD, Arrow.STANDARD);
        KNOWN_SHAPES.put(DiagramRelationshipInfo.INNER_CLASS_ARROW, DiagramPresentationModelImpl.getInnerArrow());
        KNOWN_SHAPES.put(DiagramRelationshipInfo.DELTA_SMALL, DiagramPresentationModelImpl.getDeltaSmallArrow());
        KNOWN_SHAPES.put(DiagramRelationshipInfo.WHITE_DELTA, Arrow.WHITE_DELTA);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/uml/presentation/DiagramPresentationModelImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagramBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

