/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.core.actions.fs.SaveDiagramAction;
import com.intellij.uml.utils.DiagramJavaBundle;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewJavaDiagram
extends AnAction {
    public NewJavaDiagram() {
        super(DiagramJavaBundle.message("action.NewJavaDiagram.text", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            NewJavaDiagram.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final VirtualFile file = NewJavaDiagram.getFile(e);
        if (file != null) {
            FileEditor[] fileEditors;
            CommandProcessor.getInstance().executeCommand(project, () -> {
                DiagramState state = new DiagramState(DiagramProvider.findByID((String)"JAVA"));
                state.setOriginalFQN("");
                state.saveTo(file, project);
                BasicUndoableAction undo = new BasicUndoableAction(new VirtualFile[]{file}){

                    public void undo() throws UnexpectedUndoException {
                        int ok = Messages.showOkCancelDialog((Project)project, (String)DiagramJavaBundle.message("dialog.message.undo.creating.java.class.diagram.0", file.getName()), (String)DiagramJavaBundle.message("dialog.title.undo", new Object[0]), (Icon)Messages.getQuestionIcon());
                        if (ok == 0) {
                            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                                try {
                                    file.delete((Object)this);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            });
                        }
                    }

                    public void redo() throws UnexpectedUndoException {
                    }
                };
                UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undo);
            }, DiagramJavaBundle.message("command.name.create.new.java.class.diagram", new Object[0]), (Object)"Create New Java Class Diagram");
            for (FileEditor editor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(file, true)) {
                if (!(editor instanceof UmlFileEditorImpl)) continue;
                UmlFileEditorImpl editorImpl = (UmlFileEditorImpl)editor;
                if (DumbService.isDumb((Project)project) && !editorImpl.isDumbAware()) {
                    DumbService.getInstance((Project)project).runWhenSmart(() -> NewJavaDiagram.showDependencies(editorImpl));
                    break;
                }
                NewJavaDiagram.showDependencies(editorImpl);
                break;
            }
        }
    }

    private static void showDependencies(@NotNull UmlFileEditorImpl editor) {
        if (editor == null) {
            NewJavaDiagram.$$$reportNull$$$0(1);
        }
        editor.getBuilder().getDataModel().setShowDependencies(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NewJavaDiagram.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (project == null || view == null || view.getDirectories().length == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        boolean isJavaModule = module != null && StdModuleTypes.JAVA.getId().equals(module.getModuleTypeName());
        e.getPresentation().setEnabledAndVisible(isJavaModule);
    }

    @Nullable
    public static VirtualFile getFile(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null) {
            file = project.getBaseDir();
        }
        if (file != null && !file.isDirectory()) {
            file = file.getParent();
        }
        FileSaverDescriptor descriptor = new FileSaverDescriptor(DiagramJavaBundle.message("dialog.title.create.java.class.diagram", new Object[0]), DiagramJavaBundle.message("dialog.description.set.diagram.name", new Object[0]), new String[]{"uml"});
        FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
        VirtualFileWrapper result = dialog.save(file, "diagram.uml");
        return result == null ? null : SaveDiagramAction.getWrapperWithUmlExtension(result).getVirtualFile(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/java/actions/NewJavaDiagram";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

