/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uml.utils.DiagramBundle;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewJavaClassElement
extends DiagramCreateNewNodeElementAction<PsiElement, Runnable> {
    public NewJavaClassElement(String name, String description, Icon icon) {
        super(name, description, icon);
    }

    public NewJavaClassElement(@NotNull Supplier<String> dynamicName, @NotNull Supplier<String> dynamicDescription, Icon icon) {
        if (dynamicName == null) {
            NewJavaClassElement.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            NewJavaClassElement.$$$reportNull$$$0(1);
        }
        super(dynamicName, dynamicDescription, icon);
    }

    public boolean isEnabledOn(PsiElement element) {
        return element instanceof PsiClass && element.getLanguage() == JavaLanguage.INSTANCE;
    }

    @Nullable
    public final Runnable prepare(PsiElement element, DiagramBuilder builder) {
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (!NewJavaClassElement.prepareClassForWrite(psiClass)) {
                return null;
            }
            try {
                return this.createWriteAction(psiClass, builder);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public abstract Runnable createWriteAction(PsiClass var1, DiagramBuilder var2) throws Exception;

    public abstract DiagramCategory getCategory();

    public final void execute(DiagramBuilder builder, Runnable run, AnActionEvent e) {
        run.run();
        DiagramCategory category = this.getCategory();
        boolean enabled = builder.getPresentation().isCategoryEnabled(category);
        if (!enabled) {
            builder.getPresentation().setCategoryEnabled(category, true);
            builder.update(false, true);
        }
    }

    public static boolean prepareClassForWrite(PsiClass psiClass) {
        boolean prepared = CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])new PsiElement[]{psiClass});
        if (!prepared) {
            Messages.showErrorDialog((Project)psiClass.getProject(), (String)DiagramBundle.message((String)"class.is.readonly", (Object[])new Object[]{psiClass.getName()}), (String)DiagramBundle.message((String)"error", (Object[])new Object[0]));
        }
        return prepared;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dynamicName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dynamicDescription";
                break;
            }
        }
        objectArray[1] = "com/intellij/uml/java/actions/NewJavaClassElement";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

