/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.JavaParameterTableModel;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.DiagramJavaBundle;
import com.intellij.uml.utils.UmlPsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewMethodDialog
extends JavaChangeSignatureDialog {
    private static final Logger LOG = Logger.getInstance((String)CreateNewMethodDialog.class.getName());
    private ComboBoxVisibilityPanel<String> myModifiersPanel;

    CreateNewMethodDialog(@NotNull Project project, @NotNull PsiMethod method, final @NotNull PsiClass clazz) {
        if (project == null) {
            CreateNewMethodDialog.$$$reportNull$$$0(0);
        }
        if (method == null) {
            CreateNewMethodDialog.$$$reportNull$$$0(1);
        }
        if (clazz == null) {
            CreateNewMethodDialog.$$$reportNull$$$0(2);
        }
        super(project, new JavaMethodDescriptor(method){

            public boolean canChangeVisibility() {
                return !clazz.isInterface();
            }
        }, false, null);
        this.setTitle(DiagramBundle.message((String)(method.isConstructor() ? "create.new.constructor.dialog.title" : "create.new.method.dialog.title"), (Object[])new Object[0]));
        this.getRefactorAction().putValue("Name", DiagramBundle.message((String)"create.method", (Object[])new Object[0]));
    }

    @NotNull
    protected JavaParameterTableModel createParametersInfoModel(@NotNull JavaMethodDescriptor descriptor) {
        if (descriptor == null) {
            CreateNewMethodDialog.$$$reportNull$$$0(3);
        }
        return new JavaParameterTableModel((PsiElement)descriptor.getMethod().getParameterList(), this.myDefaultValueContext, (RefactoringDialog)this){

            protected ParameterTableModelItemBase<ParameterInfoImpl> createRowItem(@Nullable ParameterInfoImpl parameterInfo) {
                if (parameterInfo == null) {
                    parameterInfo = ParameterInfoImpl.createNew().withDefaultValue("null");
                }
                return super.createRowItem(parameterInfo);
            }
        };
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    protected JPanel createVisibilityPanel() {
        JPanel visibilityPanel = super.createVisibilityPanel();
        if (((JavaMethodDescriptor)this.myMethod).getMethod().isConstructor()) {
            return visibilityPanel;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)visibilityPanel, "West");
        this.myModifiersPanel = new ComboBoxVisibilityPanel(DiagramJavaBundle.message("create.new.modifier", new Object[0]), (Object[])new String[]{"", "abstract", "static", "final"}, new String[]{DiagramJavaBundle.message("none.modifier", new Object[0]), VisibilityUtil.toPresentableText((String)"abstract"), VisibilityUtil.toPresentableText((String)"static"), VisibilityUtil.toPresentableText((String)"final")});
        this.myModifiersPanel.addListener((ChangeListener)this.mySignatureUpdater);
        panel.add((Component)this.myModifiersPanel, "East");
        return panel;
    }

    protected BaseRefactoringProcessor createRefactoringProcessor() {
        List parameterInfos = this.getParameters();
        for (ParameterInfoImpl parameterInfo : parameterInfos) {
            parameterInfo.setDefaultValue("null");
        }
        return new ChangeSignatureProcessor(this.myProject, ((JavaMethodDescriptor)this.myMethod).getMethod(), false, this.getVisibility(), this.getMethodName(), this.getReturnType(), parameterInfos.toArray(new ParameterInfoImpl[0]), this.getExceptions(), this.myMethodsToPropagateParameters, this.myMethodsToPropagateExceptions);
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor) {
        super.invokeRefactoring(processor);
        if (this.myModifiersPanel == null) {
            return;
        }
        String modifier = (String)this.myModifiersPanel.getVisibility();
        if (StringUtil.isEmpty((String)modifier)) {
            return;
        }
        UmlPsiUtil.runWriteActionInCommandProcessor(this.myProject, (PsiElement)((JavaMethodDescriptor)this.myMethod).getMethod(), () -> {
            try {
                PsiUtil.setModifierProperty((PsiModifierListOwner)((JavaMethodDescriptor)this.myMethod).getMethod(), (String)modifier, (boolean)true);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    protected String doCalculateSignature(PsiMethod method) {
        String modifier;
        PsiMethod methodCopy = (PsiMethod)method.copy();
        if (this.myModifiersPanel != null && !StringUtil.isEmpty((String)(modifier = (String)this.myModifiersPanel.getVisibility()))) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)methodCopy, (String)modifier, (boolean)true);
        }
        return super.doCalculateSignature(methodCopy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/java/actions/CreateNewMethodDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createParametersInfoModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

