/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import java.util.Comparator;

public class JavaUmlVisibilityManager
extends AbstractUmlVisibilityManager {
    private static final VisibilityLevel[] levels = new VisibilityLevel[]{new VisibilityLevel("public"), new VisibilityLevel("packageLocal", "package"), new VisibilityLevel("protected"), new VisibilityLevel("private", DiagramBundle.message((String)"visibility.level.all", (Object[])new Object[0]))};
    private static final Comparator<VisibilityLevel> COMPARATOR = (o1, o2) -> {
        int ind2;
        int ind1 = ArrayUtil.indexOf((Object[])levels, (Object)o1);
        return ind1 == (ind2 = ArrayUtil.indexOf((Object[])levels, (Object)o2)) ? 0 : (ind1 < 0 ? 1 : ind1 - ind2);
    };

    public VisibilityLevel[] getVisibilityLevels() {
        return levels;
    }

    public VisibilityLevel getVisibilityLevel(Object element) {
        if (element instanceof JavaProperty) {
            element = ((JavaProperty)element).getPropertyMethod();
        }
        if (element instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierList = (PsiModifierListOwner)element;
            if (modifierList.hasModifierProperty("public")) {
                return levels[0];
            }
            if (modifierList.hasModifierProperty("packageLocal")) {
                return levels[1];
            }
            if (modifierList.hasModifierProperty("protected")) {
                return levels[2];
            }
            if (modifierList.hasModifierProperty("private")) {
                return levels[3];
            }
        }
        return null;
    }

    public Comparator<VisibilityLevel> getComparator() {
        return COMPARATOR;
    }

    public boolean isRelayoutNeeded() {
        return true;
    }
}

