/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramPsiScopeManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.JavaUmlColorManager;
import com.intellij.uml.java.JavaUmlDataModel;
import com.intellij.uml.java.JavaUmlElementManager;
import com.intellij.uml.java.JavaUmlExtras;
import com.intellij.uml.java.JavaUmlRelationshipManager;
import com.intellij.uml.java.JavaUmlVfsResolver;
import com.intellij.uml.java.JavaUmlVisibilityManager;
import com.intellij.uml.java.actions.NewEnumConstant;
import com.intellij.uml.java.actions.NewJavaClass;
import com.intellij.uml.java.actions.NewJavaConstructor;
import com.intellij.uml.java.actions.NewJavaEnum;
import com.intellij.uml.java.actions.NewJavaField;
import com.intellij.uml.java.actions.NewJavaInterface;
import com.intellij.uml.java.actions.NewJavaMethod;
import com.intellij.uml.java.actions.NewJavaRecord;
import com.intellij.uml.utils.DiagramBundle;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUmlProvider
extends DiagramProvider<PsiElement> {
    public static final String ID = "JAVA";
    private final JavaUmlVisibilityManager myVisibilityManager;
    private final JavaUmlCategoryManager myCategoryManager;
    private final JavaUmlElementManager myElementManager;
    private final JavaUmlVfsResolver myVfsResolver;
    private final JavaUmlColorManager myColorManager = new JavaUmlColorManager();
    private final JavaUmlRelationshipManager myRelationshipManager = new JavaUmlRelationshipManager();
    private final JavaUmlExtras myExtras = new JavaUmlExtras();
    private static final DiagramEdgeCreationPolicy<PsiElement> EDGE_CREATION_POLICY = new DiagramEdgeCreationPolicy<PsiElement>(){

        public boolean acceptSource(@NotNull DiagramNode<PsiElement> source) {
            if (source == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!(source.getIdentifyingElement() instanceof PsiClass)) {
                return false;
            }
            PsiClass psiClass = (PsiClass)source.getIdentifyingElement();
            PsiFile file = psiClass.getContainingFile();
            Project prj = psiClass.getProject();
            if (file == null) {
                return false;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            return ProjectRootManager.getInstance((Project)prj).getFileIndex().isInSource(virtualFile);
        }

        public boolean acceptTarget(@NotNull DiagramNode<PsiElement> target) {
            if (target == null) {
                1.$$$reportNull$$$0(1);
            }
            return target.getIdentifyingElement() instanceof PsiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/java/JavaUmlProvider$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptTarget";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DiagramCreateNewElementAction[] myActions = new DiagramCreateNewElementAction[]{new NewJavaClass(), new NewJavaInterface(), new NewJavaEnum(), new NewJavaRecord()};
    private final DiagramCreateNewNodeElementAction[] myNodeElementActions = new DiagramCreateNewNodeElementAction[]{new NewJavaField(), new NewJavaMethod(), new NewJavaConstructor(), new NewEnumConstant()};

    public JavaUmlProvider() {
        this.myVisibilityManager = new JavaUmlVisibilityManager();
        this.myCategoryManager = new JavaUmlCategoryManager();
        this.myElementManager = new JavaUmlElementManager();
        this.myVfsResolver = new JavaUmlVfsResolver();
        this.myElementManager.setUmlProvider(this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public JavaUmlVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    public JavaUmlCategoryManager getNodeContentManager() {
        return this.myCategoryManager;
    }

    public JavaUmlElementManager getElementManager() {
        return this.myElementManager;
    }

    public JavaUmlVfsResolver getVfsResolver() {
        return this.myVfsResolver;
    }

    public JavaUmlRelationshipManager getRelationshipManager() {
        return this.myRelationshipManager;
    }

    public String getPresentableName() {
        return DiagramBundle.message((String)"uml.java.presentable.name", (Object[])new Object[0]);
    }

    public DiagramDataModel<PsiElement> createDataModel(@NotNull Project project, @Nullable PsiElement element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            JavaUmlProvider.$$$reportNull$$$0(0);
        }
        return new JavaUmlDataModel(project, element, file, presentationModel);
    }

    public DiagramColorManager getColorManager() {
        return this.myColorManager;
    }

    @NotNull
    public JavaUmlExtras getExtras() {
        JavaUmlExtras javaUmlExtras = this.myExtras;
        if (javaUmlExtras == null) {
            JavaUmlProvider.$$$reportNull$$$0(1);
        }
        return javaUmlExtras;
    }

    public DiagramEdgeCreationPolicy<PsiElement> getEdgeCreationPolicy() {
        return EDGE_CREATION_POLICY;
    }

    public DiagramCreateNewElementAction[] getCreateNewActions() {
        return this.myActions;
    }

    public DiagramCreateNewNodeElementAction<PsiElement, ?>[] getCreateNewNodeElementActions() {
        return this.myNodeElementActions;
    }

    public DiagramScopeManager<PsiElement> createScopeManager(Project project) {
        return new DiagramPsiScopeManager(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtras";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

