/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.utils.DiagramBundle;
import icons.UmlIcons;

public class JavaUmlCategoryManager
extends AbstractDiagramNodeContentManager {
    public static final DiagramCategory FIELDS = new DiagramCategory(DiagramBundle.message((String)"category.name.fields", (Object[])new Object[0]), AllIcons.Nodes.Field);
    public static final DiagramCategory CONSTRUCTORS = new DiagramCategory(DiagramBundle.message((String)"category.name.constructors", (Object[])new Object[0]), UmlIcons.Constructor);
    public static final DiagramCategory METHODS = new DiagramCategory(DiagramBundle.message((String)"category.name.methods", (Object[])new Object[0]), AllIcons.Nodes.Method);
    public static final DiagramCategory PROPERTIES = new DiagramCategory(DiagramBundle.message((String)"category.name.properties", (Object[])new Object[0]), AllIcons.Nodes.Property);
    public static final DiagramCategory INNER_CLASSES = new DiagramCategory(DiagramBundle.message((String)"category.name.inner.classes", (Object[])new Object[0]), UmlIcons.Innerclass, false, true);
    private static final DiagramCategory[] CATEGORIES = new DiagramCategory[]{FIELDS, CONSTRUCTORS, METHODS, PROPERTIES, INNER_CLASSES};

    public DiagramCategory[] getContentCategories() {
        return CATEGORIES;
    }

    public boolean isInCategory(Object element, DiagramCategory category, DiagramState presentation) {
        boolean propEnabled = presentation.isCategoryEnabled(PROPERTIES);
        if (FIELDS.equals((Object)category)) {
            if (element instanceof PsiField) {
                if (propEnabled) {
                    return JavaProperty.create((PsiField)element) == null;
                }
                return true;
            }
        } else {
            if (CONSTRUCTORS.equals((Object)category)) {
                return element instanceof PsiMethod && ((PsiMethod)element).isConstructor();
            }
            if (METHODS.equals((Object)category)) {
                if (element instanceof PsiMethod && !((PsiMethod)element).isConstructor()) {
                    PsiMethod method = (PsiMethod)element;
                    if (propEnabled) {
                        return JavaProperty.create(method) == null;
                    }
                    return true;
                }
            } else if (PROPERTIES.equals((Object)category)) {
                return element instanceof JavaProperty;
            }
        }
        return false;
    }
}

