/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.core.actions.ShowDiagramBase;
import com.intellij.uml.utils.DiagramBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class ShowDiagramPopup
extends ShowDiagramBase
implements PopupAction {
    String[] actions = new String[]{"Uml.ShowSubtypes", "Uml.ShowSupers", "Uml.ShowUsed", "EditSource"};

    @Override
    protected boolean isPopup() {
        return true;
    }

    @Override
    public String getFeatureId() {
        return "diagram.show.popup";
    }

    @Override
    protected Runnable show(Object element, DiagramProvider provider, Project project, RelativePoint popupLocation, Collection additionalElements) {
        VirtualFile file = this.getVirtualFile(project, provider);
        UmlGraphBuilder builder = UmlGraphBuilderFactory.create(project, provider, element, file);
        builder.setPopupMode(true);
        builder.getPresentationModel().registerActions();
        DiagramDataModel model = builder.getDataModel();
        if (additionalElements != null) {
            for (Object additionalElement : additionalElements) {
                model.addElement(additionalElement);
            }
        }
        builder.getView().getCanvasComponent().setBackground((Color)JBColor.GRAY);
        model.setupScopeManager(element, false);
        if (model instanceof DiagramDataModel.AsyncDataLoader) {
            DiagramDataModel.AsyncDataLoader asyncDataLoader = (DiagramDataModel.AsyncDataLoader)model;
            return () -> asyncDataLoader.refreshDataModelAsync().onSuccess(o -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
                if (!project.isDisposed()) {
                    builder.updateGraph();
                    model.setModelInitializationFinished();
                    String title = this.getTitle(project, element, provider, builder.getPresentation(), additionalElements);
                    this.doShow(popupLocation, builder, title).run();
                }
            })).onError(t -> {
                if (!(t instanceof ProcessCanceledException) && !(t instanceof CancellationException)) {
                    Logger.getInstance(ShowDiagramPopup.class).error("Unable to refresh diagram model async", t);
                }
            });
        }
        model.refreshDataModel();
        builder.updateGraph();
        model.setModelInitializationFinished();
        String title = this.getTitle(project, element, provider, builder.getPresentation(), additionalElements);
        return this.doShow(popupLocation, builder, title);
    }

    @Nullable
    protected VirtualFile getVirtualFile(Project project, DiagramProvider provider) {
        return null;
    }

    @Nls
    protected String getTitle(Project project, Object element, DiagramProvider provider, DiagramState presentation, Collection additionalElements) {
        return DiagramBundle.message((String)"show.diagram.popup.title", (Object[])new Object[]{provider.getActionName(this.isPopup()), provider.getElementManager().getEditorTitle(element, presentation, additionalElements)});
    }

    protected Runnable doShow(RelativePoint popupLocation, DiagramBuilder builder, @NlsContexts.DialogTitle String title) {
        Graph2DView view = builder.getView();
        JComponent focusTarget = view.getJComponent();
        Project project = builder.getProject();
        Ref ref = new Ref();
        PopupUpdateProcessor updateProcessor = this.createUpdateProcessor(builder, project, (Ref<JBPopup>)ref);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)new UmlGraphZoomableViewport(builder)), focusTarget).setResizable(true).setFocusable(true).setMovable(true).setMayBeParent(true).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setTitle(title).setTitleIcon(new ActiveIcon(AllIcons.FileTypes.Diagram, AllIcons.FileTypes.Diagram)).setCancelOnOtherWindowOpen(false).setCancelOnWindowDeactivation(false).setRequestFocus(!this.isCalledFromJList()).createPopup();
        ref.set((Object)popup);
        Disposer.register((Disposable)popup, (Disposable)builder);
        builder.relayout();
        DiagramUtils.setBestPopupSizeForGraph((JBPopup)popup, (DiagramBuilder)builder);
        return () -> {
            builder.setPopup(popup);
            popup.show(popupLocation);
            if (this.isCalledFromJList()) {
                PopupPositionManager.positionPopupInBestPosition((JBPopup)((JBPopup)ref.get()), null, null);
            }
            builder.getGraphBuilder().fitContent();
            this.registerUmlActionsOnComponent(focusTarget);
            view.adjustScrollBarVisibility();
            view.adjustScrollBarVisibility();
            GraphViewUtil.addDataProvider((Graph2DView)view, dataId -> UmlFileEditorImpl.getData(dataId, builder));
        };
    }

    private PopupUpdateProcessor createUpdateProcessor(final DiagramBuilder builder, final Project project, final Ref<JBPopup> ref) {
        return new PopupUpdateProcessor(project){

            public void updatePopup(Object o) {
                PsiElement element = o instanceof PsiElement ? (PsiElement)o : null;
                Module module = o instanceof Module ? (Module)o : null;
                DataContext context = dataId -> {
                    if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                        return element;
                    }
                    if (LangDataKeys.MODULE.is(dataId) || LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                        return module;
                    }
                    return null;
                };
                Object newObj = builder.getProvider().getElementManager().findInDataContext(context);
                JBPopup popup = (JBPopup)ref.get();
                if (newObj != null) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed(ShowDiagramPopup.this.getFeatureId());
                    builder.getDataModel().rebuild(newObj);
                    builder.update(true, true);
                    builder.relayout();
                    builder.getGraphBuilder().fitContent();
                    if (popup instanceof AbstractPopup) {
                        popup.setCaption(ShowDiagramPopup.this.getTitle(project, element, builder.getProvider(), builder.getPresentation(), Collections.emptyList()));
                    }
                    Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    DiagramUtils.setBestPopupSizeForGraph((JBPopup)popup, (DiagramBuilder)builder);
                    if (focusOwner instanceof JComponent) {
                        PopupPositionManager.positionPopupInBestPosition((JBPopup)popup, null, null);
                    }
                }
            }
        };
    }

    protected void registerUmlActionsOnComponent(JComponent component) {
        ActionManager manager = ActionManager.getInstance();
        for (String action_id : this.actions) {
            AnAction action = manager.getAction(action_id);
            if (action == null) continue;
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
    }
}

