/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.core.actions.ShowDiagramBase;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiagram
extends ShowDiagramBase {
    @Override
    protected boolean isPopup() {
        return false;
    }

    @Override
    @Nullable
    protected Runnable show(Object element, DiagramProvider provider, Project project, RelativePoint point, Collection additionalElements) {
        return ShowDiagram.createShowDiagramRunnable(element, provider, project, additionalElements);
    }

    @Nullable
    public static Runnable createShowDiagramRunnable(Object element, DiagramProvider provider, Project project, Collection additionalElements) {
        String url = "uml://" + provider.getID() + "/" + provider.getVfsResolver().getQualifiedName(element);
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (virtualFile instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)virtualFile;
            file.setState(null);
            String text = provider.getElementManager().getEditorTitle(element, new DiagramState(), additionalElements);
            if (text != null) {
                file.setPresentableName(text);
            }
            if (file.getProject() == null) {
                file.setProject(project);
            }
            return () -> {
                file.putUserData(DiagramProvider.ORIGINAL_ELEMENT, element);
                UmlGraphBuilder builder = UmlGraphBuilderFactory.create(project, provider, element, file);
                DiagramDataModel dataModel = builder.getDataModel();
                if (dataModel == null) {
                    Disposer.dispose((Disposable)builder);
                    return;
                }
                for (Object additionalElement : additionalElements) {
                    dataModel.addElement(additionalElement);
                }
                if (dataModel instanceof DiagramDataModel.AsyncDataLoader) {
                    ((DiagramDataModel.AsyncDataLoader)dataModel).refreshDataModelAsync().onSuccess(o -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
                        if (!project.isDisposed()) {
                            dataModel.setModelInitializationFinished();
                            new ShowDiagramCallback(project, file, builder, element).run();
                        }
                    })).onError(t -> {
                        if (!(t instanceof ProcessCanceledException) && !(t instanceof CancellationException)) {
                            Logger.getInstance(ShowDiagram.class).error("Unable to refresh diagram model async", t);
                        }
                    });
                } else {
                    dataModel.refreshDataModel();
                    dataModel.setModelInitializationFinished();
                    ApplicationManager.getApplication().invokeLater((Runnable)new ShowDiagramCallback(project, file, builder, element));
                }
            };
        }
        return null;
    }

    private static final class ShowDiagramCallback
    implements Runnable {
        private final Project myProject;
        private final UmlVirtualFileSystem.UmlVirtualFile myFile;
        private final DiagramBuilder myBuilder;
        @Nullable
        private final Object myElement;

        private ShowDiagramCallback(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull DiagramBuilder builder, @Nullable Object element) {
            if (project == null) {
                ShowDiagramCallback.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ShowDiagramCallback.$$$reportNull$$$0(1);
            }
            if (builder == null) {
                ShowDiagramCallback.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myFile = file;
            this.myBuilder = builder;
            this.myElement = element;
        }

        @Override
        public void run() {
            FileEditor[] editors;
            UmlVirtualFileSystem.setInitialized(this.myFile);
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                this.myFile.putUserData(FileEditorProvider.KEY, FileEditorProviderManager.getInstance().getProviders(this.myProject, (VirtualFile)this.myFile)[0]);
            }
            if ((editors = FileEditorManager.getInstance((Project)this.myProject).openFile((VirtualFile)this.myFile, true)).length == 0) {
                Disposer.dispose((Disposable)this.myBuilder);
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myBuilder.update(false, true);
                this.myBuilder.getGraphBuilder().fitContent();
                for (Object o : this.myBuilder.getDataModel().getNodes()) {
                    DiagramNode node = (DiagramNode)o;
                    if (!node.getIdentifyingElement().equals(this.myElement)) continue;
                    this.myBuilder.setSelected(node, true);
                    break;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/uml/core/actions/ShowDiagram$ShowDiagramCallback";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

