/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.actions.GraphActionWrapper;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.utils.DiagramBundle;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DeleteSelectionWrapper
extends GraphActionWrapper {
    private static final Supplier<@Nls String> COMMAND_NAME = DiagramBundle.messagePointer((String)"delete.selection.command.name", (Object[])new Object[0]);
    private final String groupName;

    public DeleteSelectionWrapper(AbstractAction action, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DeleteSelectionWrapper.$$$reportNull$$$0(0);
        }
        super(action, builder);
        this.groupName = "Remove graph elements [" + builder.hashCode() + "]";
    }

    public String getID() {
        return "DeleteAction";
    }

    public void doAction(ActionEvent e) {
        DiagramBuilder builder = this.getBuilder();
        List selectedNodes = this.getSelectedNodes();
        List selectedEdges = this.getSelectedEdges();
        DiagramDataModel dataModel = builder.getDataModel();
        if (selectedEdges.size() == 1 && selectedNodes.size() == 0) {
            DiagramEdge edge = builder.getEdgeObject((Edge)selectedEdges.get(0));
            if (edge != null && !(edge instanceof DiagramNoteEdge)) {
                dataModel.removeEdge(edge);
            }
            return;
        }
        Runnable deleteNodes = () -> {
            for (Node node : selectedNodes) {
                DiagramNode umlNode = builder.getNodeObject(node);
                if (umlNode == null) continue;
                DeleteSelectionWrapper.deleteNode(umlNode, dataModel);
            }
            if (!selectedNodes.isEmpty()) {
                builder.getDataModel().refreshDataModel();
                builder.update(true, true);
                builder.updateView();
                JBPopup popup = builder.getPopup();
                if (popup != null) {
                    builder.getView().updateView();
                    DiagramUtils.setBestPopupSizeForGraph((JBPopup)popup, (DiagramBuilder)builder);
                }
            }
        };
        DiagramAction.performCommand((DiagramBuilder)builder, (Runnable)deleteNodes, (String)COMMAND_NAME.get(), (String)this.groupName, (PsiElement[])new PsiElement[0]);
    }

    public static void deleteNode(DiagramNode umlNode, DiagramDataModel<?> dataModel) {
        if (umlNode instanceof DiagramNoteNode) {
            dataModel.removeNote((DiagramNoteNode)umlNode);
        } else {
            dataModel.removeNode(umlNode);
            Map notes = dataModel.getNotes();
            if (notes.containsKey(umlNode)) {
                dataModel.removeNote((DiagramNoteNode)notes.get(umlNode));
            }
        }
    }

    public boolean isEnabled() {
        return super.isEnabled() && DiagramNodeEditorManager.getInstance().getCurrentCellEditor() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/uml/core/actions/DeleteSelectionWrapper", "<init>"));
    }

    public static class DeleteSelectedItemDiagramAction
    extends DiagramAction {
        public DeleteSelectedItemDiagramAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.delete", (Object[])new Object[0]), ActionsBundle.message((String)"action.$Delete.description", (Object[])new Object[0]), null);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DeleteSelectedItemDiagramAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            this.setShortcutSet(CommonShortcuts.getDelete());
        }

        public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder builder) {
            DeleteSelectionWrapper wrapper;
            if (e == null) {
                DeleteSelectedItemDiagramAction.$$$reportNull$$$0(1);
            }
            return !(wrapper = new DeleteSelectionWrapper(null, builder)).getSelectedNodes().isEmpty() || !wrapper.getSelectedEdges().isEmpty();
        }

        public void perform(@NotNull AnActionEvent e) {
            DiagramBuilder builder;
            if (e == null) {
                DeleteSelectedItemDiagramAction.$$$reportNull$$$0(2);
            }
            if ((builder = DeleteSelectedItemDiagramAction.getBuilder((AnActionEvent)e)) != null) {
                new DeleteSelectionWrapper(null, builder).actionPerformed(null);
            }
        }

        public String getActionName() {
            return "DeleteAction";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/uml/core/actions/DeleteSelectionWrapper$DeleteSelectedItemDiagramAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

