/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileType;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.VcsUtils;
import com.intellij.util.containers.FixedHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    @NonNls
    public static final String PROTOCOL = "uml";
    @NonNls
    public static final String PROTOCOL_PREFIX = "uml://";
    @NonNls
    public static final String CHANGES = "uml://$SHOW_CHANGES$/";
    private final Map<String, VirtualFile> cache = new FixedHashMap(30);

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        VirtualFile file;
        if (path == null) {
            UmlVirtualFileSystem.$$$reportNull$$$0(0);
        }
        if ((file = this.cache.get(path)) == null) {
            file = new UmlVirtualFile(path);
            this.cache.put(path, file);
        }
        return file;
    }

    public void refresh(boolean asynchronous) {
    }

    public static boolean isInitialized(VirtualFile vf) {
        return vf instanceof UmlVirtualFile && ((UmlVirtualFile)vf).isInitialized();
    }

    public static void setInitialized(VirtualFile vf) {
        if (vf instanceof UmlVirtualFile) {
            ((UmlVirtualFile)vf).setInitialized(true);
        }
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            UmlVirtualFileSystem.$$$reportNull$$$0(1);
        }
        return this.findFileByPath(path);
    }

    public static boolean isUmlVirtualFile(VirtualFile file) {
        return file instanceof UmlVirtualFile;
    }

    static {
        PluginVerifier.verifyUltimatePlugin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "path";
        objectArray2[1] = "com/intellij/uml/UmlVirtualFileSystem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Presentation(icon="AllIcons.FileTypes.Diagram")
    public class UmlVirtualFile
    extends VirtualFile
    implements VirtualFilePathWrapper,
    VirtualFileWithoutContent {
        private final String myName;
        private boolean initialized;
        private String myPresentableName;
        private Project myProject;
        private long myTimestamp;
        private long myModificationStamp;
        private DiagramState myState;
        private final List<DiagramBuilder> myBuilders;

        public UmlVirtualFile(String name) {
            if (name == null) {
                UmlVirtualFile.$$$reportNull$$$0(0);
            }
            this.initialized = false;
            this.myTimestamp = 0L;
            this.myModificationStamp = 0L;
            this.myState = null;
            this.myBuilders = new ArrayList<DiagramBuilder>();
            this.myName = name;
            this.updateTimeStamp();
        }

        private void updateTimeStamp() {
            this.myTimestamp = System.currentTimeMillis();
            ++this.myModificationStamp;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public DiagramProvider getUmlProvider() {
            int ind = this.myName.indexOf(47);
            if (ind == -1) {
                return null;
            }
            return DiagramProvider.findByID((String)this.myName.substring(0, ind));
        }

        @Nullable
        public String getFQN() {
            int ind = this.myName.indexOf(47);
            if (ind == -1) {
                return null;
            }
            return this.myName.substring(ind + 1);
        }

        public String getShortName() {
            if (this.myPresentableName != null) {
                return this.myPresentableName;
            }
            int ind = this.myName.lastIndexOf(46);
            return ind < 0 ? this.myName : this.myName.substring(++ind);
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            UmlVirtualFileSystem umlVirtualFileSystem = UmlVirtualFileSystem.this;
            if (umlVirtualFileSystem == null) {
                UmlVirtualFile.$$$reportNull$$$0(2);
            }
            return umlVirtualFileSystem;
        }

        @NotNull
        public String getPath() {
            String string = this.getName();
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isWritable() {
            return false;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public DiagramState getState() {
            return this.myState;
        }

        public void setState(DiagramState state) {
            this.myState = state;
        }

        @Nullable
        public VirtualFile getParent() {
            return null;
        }

        public VirtualFile[] getChildren() {
            return EMPTY_ARRAY;
        }

        @NotNull
        public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
            throw new UnsupportedOperationException("getOutputStream is not implemented in : " + ((Object)((Object)this)).getClass());
        }

        public byte @NotNull [] contentsToByteArray() throws IOException {
            throw new UnsupportedOperationException("contentsToByteArray is not implemented in : " + ((Object)((Object)this)).getClass());
        }

        public long getTimeStamp() {
            return this.myTimestamp;
        }

        public long getLength() {
            return 0L;
        }

        public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("getInputStream is not implemented in : " + ((Object)((Object)this)).getClass());
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        public String getPresentableName() {
            if (this.getUmlProvider() == null) {
                return VcsUtils.isShowChangesFile(this) ? DiagramBundle.message((String)"uml.file.name.for.changes", (Object[])new Object[]{this.getChangeListName()}) : DiagramBundle.message((String)"uml.class.diagram.file.name", (Object[])new Object[]{this.getShortName()});
            }
            return VcsUtils.isShowChangesFile(this) ? DiagramBundle.message((String)"uml.file.name.for.changes", (Object[])new Object[]{this.getChangeListName()}) : this.getShortName();
        }

        private String getChangeListName() {
            return this.getPath().substring(UmlVirtualFileSystem.CHANGES.length()).split("/")[1];
        }

        public boolean equals(Object obj) {
            return obj instanceof UmlVirtualFile && this.myName.equals(((UmlVirtualFile)((Object)obj)).getName());
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        @NotNull
        public FileType getFileType() {
            DiagramFileType diagramFileType = DiagramFileType.INSTANCE;
            if (diagramFileType == null) {
                UmlVirtualFile.$$$reportNull$$$0(4);
            }
            return diagramFileType;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        public void setPresentableName(String presentableName) {
            this.myPresentableName = presentableName;
        }

        @NotNull
        public String getPresentablePath() {
            String string = this.getPresentableName();
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean enforcePresentableName() {
            return true;
        }

        public Project getProject() {
            return this.myProject;
        }

        public void setProject(Project project) {
            this.myProject = project;
            Disposer.register((Disposable)this.myProject, this::clearCache);
        }

        @Nullable
        public DiagramBuilder getBuilder() {
            return this.myBuilders.isEmpty() ? null : this.myBuilders.get(this.myBuilders.size() - 1);
        }

        public void addBuilder(final DiagramBuilder builder) {
            if (!this.myBuilders.contains(builder)) {
                this.myBuilders.add(builder);
            }
            Disposer.register((Disposable)builder, (Disposable)new Disposable(){

                public void dispose() {
                    UmlVirtualFile.this.myBuilders.remove(builder);
                    if (UmlVirtualFile.this.myBuilders.isEmpty()) {
                        UmlVirtualFile.this.clearCache();
                    }
                }
            });
        }

        public void clearCache() {
            this.myProject = null;
            this.myState = null;
            this.myBuilders.clear();
            this.initialized = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileSystem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

