/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DataProviderFactory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlGraphBuilderFactory {
    private UmlGraphBuilderFactory() {
    }

    @NotNull
    public static UmlGraphBuilder create(@NotNull Project project, @NotNull DiagramProvider provider, @Nullable Object element, @Nullable VirtualFile file) {
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(1);
        }
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(graph);
        view.getJComponent().putClientProperty("Diagram-View-Component-Key", Boolean.TRUE);
        DiagramPresentationModel presentationModel = provider.createPresentationModel(project, graph);
        if (presentationModel == null) {
            presentationModel = new DiagramPresentationModelImpl(graph, project, provider);
        }
        DiagramDataModel model = provider.createDataModel(project, element, file, presentationModel);
        final UmlGraphBuilder builder = new UmlGraphBuilder(project, graph, view, model, presentationModel);
        graph.addDataProvider((Object)"PROJECT", DataProviderFactory.create((Object)project));
        graph.addDataProvider((Object)"ORIGINAL_ELEMENT", DataProviderFactory.create((Object)element));
        graph.addDataProvider((Object)"GRAPH_BUILDER", DataProviderFactory.create((Object)((Object)builder)));
        builder.putUserData(Utils.UML_PROVIDER, provider);
        model.putUserData(Utils.GRAPH_BUILDER, (Object)builder);
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            ((UmlVirtualFileSystem.UmlVirtualFile)file).addBuilder(builder);
            builder.putUserData(UmlGraphBuilder.EDITOR_FILE, file);
        }
        graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){

            public void onGraph2DSelectionEvent(Graph2DSelectionEvent e) {
                if (e.isNodeSelection()) {
                    builder.getGraphPresentationModel().onSelectionChanged(e);
                }
            }
        });
        UmlGraphBuilder umlGraphBuilder = builder;
        if (umlGraphBuilder == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(2);
        }
        return umlGraphBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlGraphBuilderFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlGraphBuilderFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

