/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigBundle;
import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.CloudConfigUi;
import com.intellij.cloudConfig.CloudConfigWidget;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.util.PairFunction;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarInfoManager {
    private static final Logger LOG = Logger.getInstance(StatusBarInfoManager.class);
    public static final StatusBarInfoManager EMPTY = new StatusBarInfoManager(){

        @Override
        public void update(boolean create) {
        }
    };

    public void update(boolean create) {
        WindowManager windowManager = WindowManager.getInstance();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar = windowManager.getStatusBar(project);
            if (statusBar == null) {
                LOG.info("=== StatusBar.update no status bar for project: " + project + " ===");
                continue;
            }
            StatusBarWidget widget = statusBar.getWidget("CloudConfig");
            if (widget instanceof CloudConfigWidget) {
                ((CloudConfigWidget)widget).update();
                continue;
            }
            if (create) {
                statusBar.addWidget((StatusBarWidget)new CloudConfigWidget(), StatusBar.Anchors.after((String)"ReadOnlyAttribute"));
                LOG.info("=== StatusBar.update create ===");
                continue;
            }
            LOG.info("=== StatusBar.update another widget: " + widget + " ===");
        }
    }

    static boolean isConnected() {
        return CloudConfigManager.getInstance().getStatusInfo() == StatusInfo.JBA_CONNECTED;
    }

    static Runnable showPopupMessage(@Nullable Project project) {
        return () -> {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar == null) {
                return;
            }
            JComponent component = ((IdeStatusBarImpl)statusBar).getWidgetComponent("CloudConfig");
            if (component == null) {
                return;
            }
            CloudConfigManager manager = CloudConfigManager.getInstance();
            String message = CloudConfigBundle.message(manager.getStatusInfo() == StatusInfo.JBA_IO_ERROR ? "error.connected.message" : (manager.hasPluginsUpdate() ? "update.plugins.message" : "connected.message"), new Object[0]);
            IdeTooltip tooltip = new IdeTooltip((Component)component, new Point(), (JComponent)new JLabel(message), new Object[0]);
            IdeTooltipManager.getInstance().show(tooltip, true, false);
        };
    }

    public static void showStartNotification() {
        Notification notification = new Notification(CloudConfigUi.NotificationGroupHolder.GROUP.getDisplayId(), CloudConfigBundle.message("accepted.title", new Object[0]), CloudConfigBundle.message("accepted.message", new Object[0]), NotificationType.INFORMATION);
        notification.setIcon(AllIcons.General.Settings);
        notification.addAction((AnAction)new NotificationAction(CloudConfigBundle.message("enable.cloud.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                Project project = e.getProject();
                notification.expire();
                StatusBarInfoManager.connectInstance(project, StatusBarInfoManager.showPopupMessage(project));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/cloudConfig/StatusBarInfoManager$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(null);
    }

    static void connectInstance(@Nullable Project project, @NotNull Runnable successRun) {
        block6: {
            int result;
            boolean[] autoUpdatePlugins;
            if (successRun == null) {
                StatusBarInfoManager.$$$reportNull$$$0(0);
            }
            CloudConfigManager manager = CloudConfigManager.getInstance();
            manager.recalculateInitStatus(project);
            while (true) {
                if (manager.getStatusInfo() == StatusInfo.JBA_NOT_CONNECTED) {
                    CloudConfigUi.DialogWithCheckboxResult result2 = CloudConfigUi.showDialog("connect.message", "connect.button", "connect.plugins.auto", null);
                    if (result2 != CloudConfigUi.DialogWithCheckboxResult.NO) {
                        manager.recalculateInitStatus(project);
                        if (manager.getStatusInfo() != StatusInfo.JBA_NOT_CONNECTED) continue;
                        manager.setAutoUpdatePlugins(result2 == CloudConfigUi.DialogWithCheckboxResult.YES_WITH_EXTRA_OPTION);
                        manager.connectFirstInstance(false, successRun);
                    }
                    break block6;
                }
                autoUpdatePlugins = new boolean[1];
                result = CloudConfigUi.showCheckboxDialog(CloudConfigBundle.message("connect.this.message", StatusBarInfoManager.getUserLogin()), new String[]{CloudConfigBundle.message("connect.this.remote.button", new Object[0]), CloudConfigBundle.message("connect.this.local.button", new Object[0]), Messages.getCancelButton()}, CloudConfigBundle.message("connect.plugins.auto", new Object[0]), (PairFunction<? super Integer, ? super JCheckBox, Integer>)((PairFunction)(exitCode, checkBox) -> {
                    autoUpdatePlugins[0] = checkBox.isSelected();
                    return exitCode;
                }), null);
                if (result != 0 && result != 1) break block6;
                manager.recalculateInitStatus(project);
                if (manager.getStatusInfo() != StatusInfo.JBA_NOT_CONNECTED) break;
            }
            manager.setAutoUpdatePlugins(autoUpdatePlugins[0]);
            if (result == 0) {
                manager.connectThisInstance(true, false, successRun);
            } else {
                manager.connectFirstInstance(true, successRun);
            }
        }
    }

    @NlsSafe
    @NotNull
    static String getUserLogin() {
        String string = StringUtil.defaultIfEmpty((String)CloudConfigClientUtil.getUserLogin(), (String)"User from Toolbox App");
        if (string == null) {
            StatusBarInfoManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successRun";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserLogin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connectInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyStartupActivity
    implements StartupActivity.DumbAware {
        MyStartupActivity() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            if (!CloudConfigManager.getInstance().getStatusInfo().notDisabled()) {
                LOG.info("=== StatusBar ignored ===");
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                StatusBarWidget widget = statusBar.getWidget("CloudConfig");
                if (widget == null) {
                    statusBar.addWidget((StatusBarWidget)new CloudConfigWidget(), StatusBar.Anchors.after((String)"ReadOnlyAttribute"));
                    LOG.info("=== StatusBar.start create ===");
                } else {
                    LOG.info("=== StatusBar.start another widget: " + widget + " ===");
                }
            }, ModalityState.NON_MODAL, project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cloudConfig/StatusBarInfoManager$MyStartupActivity", "runActivity"));
        }
    }
}

