/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime;

import com.intellij.javaee.weblogic.agent.version9.mbeansModel.AbstractWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.ApplicationRuntimeWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.LogBroadcasterRuntimeWL9MBean;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ServerRuntimeWL9MBean
extends AbstractWL9MBean {
    private static final String APPLICATION_RUNTIMES_ATTRIBUTE_NAME = "ApplicationRuntimes";
    private static final String STATE_ATTRIBUTE_NAME = "State";
    private static final String LOG_BROADCASTER_RUNTIME_NAME = "LogBroadcasterRuntime";
    private static final String NAME_ATTRIBUTE_NAME = "Name";

    public ServerRuntimeWL9MBean(MBeanServerConnection connection, ObjectName beanName) {
        super(connection, beanName);
    }

    public ApplicationRuntimeWL9MBean[] getApplicationRuntimes() throws IOException, JMException {
        ObjectName[] children = this.getChildren(APPLICATION_RUNTIMES_ATTRIBUTE_NAME);
        ApplicationRuntimeWL9MBean[] applicationRuntimes = new ApplicationRuntimeWL9MBean[children.length];
        for (int i = 0; i < children.length; ++i) {
            applicationRuntimes[i] = new ApplicationRuntimeWL9MBean(this.getConnection(), children[i]);
        }
        return applicationRuntimes;
    }

    public LogBroadcasterRuntimeWL9MBean getLogBroadcasterRuntime() throws IOException, JMException {
        return new LogBroadcasterRuntimeWL9MBean(this.getConnection(), this.getChild(LOG_BROADCASTER_RUNTIME_NAME));
    }

    public String getState() throws IOException, JMException {
        return (String)this.getAttribute(STATE_ATTRIBUTE_NAME);
    }

    public ApplicationRuntimeWL9MBean findApplicationRuntimeByName(String name) throws IOException, JMException {
        ObjectName[] children;
        for (ObjectName objectName : children = this.getChildren(APPLICATION_RUNTIMES_ATTRIBUTE_NAME)) {
            ApplicationRuntimeWL9MBean applicationRuntime = new ApplicationRuntimeWL9MBean(this.getConnection(), objectName);
            if (!name.equals(applicationRuntime.getName())) continue;
            return applicationRuntime;
        }
        return null;
    }

    public String getName() throws IOException, JMException {
        return (String)this.getAttribute(NAME_ATTRIBUTE_NAME);
    }
}

