/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.agent;

import com.intellij.javaee.oss.agent.SimpleAgentException;
import com.intellij.javaee.oss.agent.SimpleAgentJob;
import com.intellij.javaee.util.ILogger;
import com.intellij.javaee.weblogic.agent.WebLogicAgent9;
import com.intellij.javaee.weblogic.agent.WebLogicAgent9Extension;
import com.intellij.javaee.weblogic.agent.dataSource.WeblogicConnectionPoolInfo;
import com.intellij.javaee.weblogic.agent.dataSource.WeblogicDataSourceDescriptor;
import com.intellij.javaee.weblogic.agent.dataSource.WeblogicDataSourceErrorHandler;
import com.intellij.javaee.weblogic.agent.dataSource.WeblogicDataSourceInfo;
import com.intellij.javaee.weblogic.agent.version9.WeblogicJMXConnector;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.AppDeploymentWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.ConfigurationManagerWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.DomainWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.EditServiceWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.TargetWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.jdbc.JDBCConnectionPoolParamsWL9Bean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.jdbc.JDBCDataSourceParamsWL9Bean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.jdbc.JDBCDataSourceWL9Bean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.jdbc.JDBCDriverParamsWL9Bean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.jdbc.JDBCPropertiesWL9Bean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.jdbc.JDBCPropertyWL9Bean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.jdbc.JDBCSystemResourceWL9MBean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;
import weblogic.management.NoAccessRuntimeException;

public class WebLogicAgent9ExtensionImpl
implements WebLogicAgent9Extension {
    private static final int START_EDIT_WAIT_TIME = 5000;
    private static final int START_EDIT_TIMEOUT = 5000;
    private static final int ACTIVATE_TIMEOUT = 5000;
    private WeblogicJMXConnector<EditServiceWL9MBean> myEditServiceConnector;
    private WebLogicAgent9 myAgent;

    public void init(WebLogicAgent9 agent) {
        this.myAgent = agent;
        this.myEditServiceConnector = WeblogicJMXConnector.createEditServiceConnector();
    }

    private ILogger getLog() {
        return this.myAgent.getAgentLog();
    }

    private JDBCSystemResourceWL9MBean[] getJDBCSystemResources() throws IOException, JMException {
        return this.myAgent.getDomainRuntimeService().getDomainConfiguration().getJDBCSystemResources();
    }

    public WeblogicDataSourceDescriptor getDatasourceDescriptor(final String name) {
        return (WeblogicDataSourceDescriptor)new AgentJobBase<WeblogicDataSourceDescriptor>(){

            @Override
            protected WeblogicDataSourceDescriptor onException() {
                return null;
            }

            protected WeblogicDataSourceDescriptor doJob() throws IOException, JMException, SimpleAgentException {
                JDBCSystemResourceWL9MBean[] jdbcSystemResources;
                for (JDBCSystemResourceWL9MBean jdbcSystemResource : jdbcSystemResources = WebLogicAgent9ExtensionImpl.this.getJDBCSystemResources()) {
                    JDBCDataSourceWL9Bean JDBCResource = jdbcSystemResource.getJDBCResource();
                    String datasourceName = JDBCResource.getName();
                    if (!datasourceName.equals(name)) continue;
                    JDBCDriverParamsWL9Bean driverParams = JDBCResource.getJDBCDriverParams();
                    JDBCPropertiesWL9Bean driverParamsProperties = driverParams.getProperties();
                    JDBCPropertyWL9Bean nameProperty = driverParamsProperties.lookupProperty("user");
                    JDBCPropertyWL9Bean passwordProperty = driverParamsProperties.lookupProperty("password");
                    String username = nameProperty.isBeanNameValid() ? nameProperty.getValue() : "";
                    String password = "";
                    try {
                        String paramPassword = driverParams.getPassword();
                        password = paramPassword == null && passwordProperty.isBeanNameValid() ? passwordProperty.getValue() : paramPassword;
                    }
                    catch (NoAccessRuntimeException e) {
                        this.getLog().error("Can't import password from datasource " + datasourceName + " due to the setting of ClearTextCredentialAccessEnabled attribute. Please add to your WebLogic startup VM parameters: -Dweblogic.management.clearTextCredentialAccessEnabled=true");
                    }
                    return new WeblogicDataSourceDescriptorImpl(username, password, driverParams.getDriverClass(), datasourceName, driverParams.getUrl());
                }
                return null;
            }
        }.perform();
    }

    public String getStagingDir() {
        try {
            return this.myAgent.getStagingDir();
        }
        catch (IOException e) {
            this.getLog().debugEx((Exception)e);
        }
        catch (JMException e) {
            this.getLog().debugEx((Exception)e);
        }
        return null;
    }

    public void createDatasource(final WeblogicDataSourceInfo info, final WeblogicConnectionPoolInfo poolInfo, final WeblogicDataSourceErrorHandler errorHandler) {
        new AgentJobBase(){

            protected Object doJob() throws IOException, JMException, SimpleAgentException {
                WebLogicAgent9ExtensionImpl.this.myAgent.connectBean(WebLogicAgent9ExtensionImpl.this.myEditServiceConnector);
                EditServiceWL9MBean editService = (EditServiceWL9MBean)WebLogicAgent9ExtensionImpl.this.myEditServiceConnector.createRootMBean();
                ConfigurationManagerWL9MBean configurationManager = editService.getConfigurationManager();
                DomainWL9MBean domain = configurationManager.startEdit(5000, 5000);
                try {
                    JDBCSystemResourceWL9MBean jdbcSystemResource = domain.createJDBCSystemResource(info.getDSName());
                    JDBCDataSourceWL9Bean jdbcResource = jdbcSystemResource.getJDBCResource();
                    JDBCDataSourceParamsWL9Bean dataSourceParams = jdbcResource.getJDBCDataSourceParams();
                    JDBCConnectionPoolParamsWL9Bean connectionPoolParams = jdbcResource.getJDBCConnectionPoolParams();
                    JDBCDriverParamsWL9Bean jdbcDriverParams = jdbcResource.getJDBCDriverParams();
                    jdbcResource.setName(info.getDSName());
                    jdbcSystemResource.setNotes(info.getNotes());
                    WebLogicAgent9ExtensionImpl.addTargets(domain, jdbcSystemResource);
                    dataSourceParams.setJNDINames(new String[]{info.getJNDIName()});
                    dataSourceParams.setRowPrefetch(info.isRowPrefetchEnabled());
                    dataSourceParams.setRowPrefetchSize(info.getRowPrefetchSize());
                    dataSourceParams.setStreamChunkSize(info.getStreamChunkSize());
                    dataSourceParams.setGlobalTransactionsProtocol(WebLogicAgent9ExtensionImpl.getGlobalTransactionProtocol(info));
                    connectionPoolParams.setCapacityIncrement(poolInfo.getCapacityIncrement());
                    connectionPoolParams.setInitialCapacity(poolInfo.getInitialCapacity());
                    connectionPoolParams.setMaxCapacity(poolInfo.getMaxCapacity());
                    jdbcDriverParams.setDriverClass(poolInfo.getDriverClassname());
                    jdbcDriverParams.setUrl(poolInfo.getUrl());
                    WebLogicAgent9ExtensionImpl.setProperties(jdbcDriverParams, poolInfo.getProperties());
                    configurationManager.save();
                    configurationManager.activate(5000L);
                    WebLogicAgent9ExtensionImpl.this.myEditServiceConnector.disconnect();
                }
                catch (JMException e) {
                    try {
                        configurationManager.stopEdit();
                    }
                    catch (JMException ignored) {
                        this.getLog().debugEx((Exception)ignored);
                    }
                    throw e;
                }
                return null;
            }

            protected Object onException(Exception e) {
                errorHandler.setError(e.getMessage());
                return null;
            }

            protected String onException() {
                throw new UnsupportedOperationException();
            }
        }.perform();
    }

    public String[] getConfiguredDataSourceNames() {
        return (String[])new AgentJobBase<String[]>(){

            protected String[] doJob() throws IOException, JMException, SimpleAgentException {
                JDBCSystemResourceWL9MBean[] resources;
                ArrayList<String> names = new ArrayList<String>();
                for (JDBCSystemResourceWL9MBean resource : resources = WebLogicAgent9ExtensionImpl.this.getJDBCSystemResources()) {
                    names.add(resource.getJDBCResource().getName());
                }
                return names.toArray(new String[0]);
            }

            @Override
            protected String[] onException() {
                return new String[0];
            }
        }.perform();
    }

    private static void addTargets(DomainWL9MBean domain, JDBCSystemResourceWL9MBean jdbcSystemResource) throws IOException, JMException {
        HashSet<TargetWL9MBean> targets = new HashSet<TargetWL9MBean>();
        AppDeploymentWL9MBean[] appDeployments = domain.getAppDeployments();
        for (AppDeploymentWL9MBean appDeployment : appDeployments) {
            TargetWL9MBean[] appTargets = appDeployment.getTargets();
            targets.addAll(Arrays.asList(appTargets));
        }
        for (TargetWL9MBean target : targets) {
            jdbcSystemResource.addTarget(target);
        }
    }

    private static JDBCDataSourceParamsWL9Bean.GlobalTransactionsProtocol getGlobalTransactionProtocol(WeblogicDataSourceInfo info) {
        if (!info.isTxDataSource()) {
            return JDBCDataSourceParamsWL9Bean.GlobalTransactionsProtocol.NONE;
        }
        return info.isEnableTwoPhaseCommit() ? JDBCDataSourceParamsWL9Bean.GlobalTransactionsProtocol.TWO_PHASE_COMMIT : JDBCDataSourceParamsWL9Bean.GlobalTransactionsProtocol.ONE_PHASE_COMMIT;
    }

    private static void setProperties(JDBCDriverParamsWL9Bean jdbcDriverParams, Properties properties) throws IOException, JMException {
        JDBCPropertiesWL9Bean propertiesBean = jdbcDriverParams.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            JDBCPropertyWL9Bean property = propertiesBean.createProperty((String)entry.getKey());
            property.setValue((String)entry.getValue());
        }
    }

    private abstract class AgentJobBase<T>
    extends SimpleAgentJob<T> {
        private AgentJobBase() {
        }

        protected ILogger getLog() {
            return WebLogicAgent9ExtensionImpl.this.getLog();
        }

        protected T onException(Exception e) {
            this.getLog().debugEx(e);
            return this.onException();
        }

        protected abstract T onException();
    }

    private static final class WeblogicDataSourceDescriptorImpl
    implements WeblogicDataSourceDescriptor {
        private final String myUsername;
        private final String myPassword;
        private final String myDriverClassName;
        private final String myDatasourceName;
        private final String myUrl;

        private WeblogicDataSourceDescriptorImpl(String username, String password, String driverClassName, String datasourceName, String url) {
            this.myUsername = username;
            this.myPassword = password;
            this.myDriverClassName = driverClassName;
            this.myDatasourceName = datasourceName;
            this.myUrl = url;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public String getDriverClassname() {
            return this.myDriverClassName;
        }

        public String getName() {
            return this.myDatasourceName;
        }

        public String getUrl() {
            return this.myUrl;
        }
    }
}

