/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.jam.JamElement;
import com.intellij.jam.JavaJamBundle;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.DeleteHandler;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class CommonModelManagerImpl
extends CommonModelManager {
    private final List<JamDeleteHandler> myDeleteHandlers = new ArrayList<JamDeleteHandler>();
    private final Map<Class<? extends CommonModelElement>, JamDeleteHandler> myHandlersMap = FactoryMap.create(key -> {
        DeleteHandler handler = (DeleteHandler)DomReflectionUtil.findAnnotationDFS((Class)key, DeleteHandler.class);
        if (handler == null) {
            return null;
        }
        try {
            Class<?> aClass = handler.handlerClass();
            if (aClass == JamDeleteHandler.class) {
                aClass = Class.forName(handler.value(), true, key.getClassLoader());
            }
            return (JamDeleteHandler)aClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    });

    public CommonModelManagerImpl() {
        this.registerDeleteHandler(new JamDeleteHandler(){

            public void addPsiElements(CommonModelElement element, Collection<? super PsiElement> result) {
                DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class);
                JamElement annoElement2 = (JamElement)ModelMergerUtil.getImplementation((Object)element, JamElement.class);
                if (domElement != null) {
                    XmlTag domElementTag = domElement.getXmlTag();
                    if (domElementTag != null) {
                        result.add((PsiElement)domElementTag);
                    }
                } else if (annoElement2 instanceof CommonModelElement) {
                    ContainerUtil.addIfNotNull(result, (Object)((CommonModelElement)annoElement2).getIdentifyingPsiElement());
                }
            }
        });
    }

    public final void registerDeleteHandler(JamDeleteHandler handler) {
        this.myDeleteHandlers.add(handler);
    }

    @Nullable
    public <T extends DomElement> T getDomElement(CommonModelElement element) {
        return (T)((DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class));
    }

    public final void deleteModelElement(CommonModelElement element, JamUserResponse response) {
        this.deleteModelElements(Collections.singletonList(element), response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteModelElements(Collection<? extends CommonModelElement> elements, JamUserResponse response) {
        String string;
        THashSet modelElements = new THashSet();
        for (CommonModelElement commonModelElement : elements) {
            if (commonModelElement == null || !commonModelElement.isValid()) continue;
            modelElements.add((Object)commonModelElement);
        }
        if (modelElements.isEmpty()) {
            return;
        }
        CommonModelElement firstElement = elements.iterator().next();
        String string2 = string = elements.size() == 1 ? JamCommonUtil.getDisplayName((Object)firstElement) : JavaJamBundle.message((String)"model.delete.items", (Object[])new Object[0]);
        if (!CommonModelManagerImpl.confirmDeletion(string, response)) {
            return;
        }
        this.addModelElements((Set<CommonModelElement>)modelElements);
        ArrayList<? extends PsiElement> psiElements = new ArrayList<PsiElement>(this.addPsiElements((Collection<? extends CommonModelElement>)modelElements));
        if (psiElements.size() > modelElements.size()) {
            ArrayList elements1 = new ArrayList(response.askUserToDeletePsiElements(psiElements, string));
            if (elements1.isEmpty()) {
                return;
            }
            psiElements.clear();
            psiElements.addAll(elements1);
        }
        Project project = firstElement.getPsiManager().getProject();
        String name = JavaJamBundle.message((String)"local.vcs.action.name.deleting.element", (Object[])new Object[]{string});
        LocalHistoryAction a = LocalHistory.getInstance().startAction(name);
        try {
            if (psiElements.isEmpty() || CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, psiElements)) {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                WriteCommandAction.writeCommandAction((Project)project).withName(JavaJamBundle.message((String)"command.name.deleting.element", (Object[])new Object[]{string})).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).withGlobalUndo().run(() -> {
                    THashSet parents = new THashSet();
                    for (PsiElement psiElement : psiElements) {
                        ContainerUtil.addIfNotNull((Collection)parents, (Object)psiElement.getParent());
                    }
                    CommonModelManagerImpl.doDelete(psiElements, response, displayName);
                    DomManager domManager = DomManager.getDomManager((Project)project);
                    block1: for (PsiElement parent : parents) {
                        if (!parent.isValid()) continue;
                        DomElement domParent = parent instanceof XmlTag ? domManager.getDomElement((XmlTag)parent) : null;
                        for (JamDeleteHandler deleteHandler : this.getDeleteHandlers(domParent == null ? parent : domParent)) {
                            if ((domParent == null || !deleteHandler.onChildrenDelete(domParent)) && (domParent != null || !deleteHandler.onChildrenDelete(parent))) continue;
                            continue block1;
                        }
                    }
                });
            }
        }
        finally {
            a.finish();
        }
        response.onDeletingHasBeenFinished();
    }

    private void addModelElements(Set<CommonModelElement> modelElements) {
        THashSet curElements = new THashSet(CommonModelManagerImpl.removeNullAndInvalidElements(modelElements));
        while (!curElements.isEmpty()) {
            THashSet newModelElements = new THashSet();
            for (CommonModelElement element : curElements) {
                for (JamDeleteHandler deleteHandler : this.getDeleteHandlers(element)) {
                    deleteHandler.addModelElements(element, (Collection)newModelElements);
                }
            }
            newModelElements.removeAll(modelElements);
            modelElements.addAll((Collection<CommonModelElement>)CommonModelManagerImpl.removeNullAndInvalidElements(newModelElements));
            curElements = newModelElements;
        }
    }

    private List<JamDeleteHandler> getDeleteHandlers(Object element) {
        JamDeleteHandler handler;
        Class<?> elementClass = element.getClass();
        if (CommonModelElement.class.isAssignableFrom(elementClass) && (handler = this.myHandlersMap.get(elementClass)) != null) {
            ArrayList<JamDeleteHandler> handlers = new ArrayList<JamDeleteHandler>(this.myDeleteHandlers);
            handlers.add(handler);
            return handlers;
        }
        return this.myDeleteHandlers;
    }

    private static <T extends Collection<CommonModelElement>> T removeNullAndInvalidElements(T curElements) {
        Iterator<CommonModelElement> it = curElements.iterator();
        while (it.hasNext()) {
            CommonModelElement element = it.next();
            if (element != null && element.isValid()) continue;
            it.remove();
        }
        return curElements;
    }

    private Collection<? extends PsiElement> addPsiElements(Collection<? extends CommonModelElement> elements) {
        THashSet collection = new THashSet();
        for (CommonModelElement commonModelElement : elements) {
            for (JamDeleteHandler deleteHandler : this.getDeleteHandlers(commonModelElement)) {
                deleteHandler.addPsiElements(commonModelElement, (Collection)collection);
            }
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            PsiElement psiElement = (PsiElement)it.next();
            if (psiElement != null && !(psiElement instanceof PsiCompiledElement) && !(psiElement instanceof FakePsiElement) && psiElement.isValid() && psiElement.getManager().isInProject(psiElement)) continue;
            it.remove();
        }
        return collection;
    }

    private static void doDelete(List<? extends PsiElement> psiElements, JamUserResponse userResponse, String displayName) {
        for (PsiElement psiElement : psiElements) {
            if (!psiElement.isValid()) continue;
            try {
                psiElement.delete();
            }
            catch (IncorrectOperationException e) {
                userResponse.logErrorWhileDeletingPsiElement(e, displayName, psiElement);
            }
        }
    }

    private static boolean confirmDeletion(String displayName, JamUserResponse response) {
        return response.showYesNoDialog(JavaJamBundle.message((String)"confirmation.text.delete.element", (Object[])new Object[]{displayName}), JavaJamBundle.message((String)"message.title.deleting.element", (Object[])new Object[]{displayName}), Messages.getQuestionIcon()) == 0;
    }
}

