/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamReferenceContributor;
import com.intellij.jam.JamReferenceContributorKt;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

public class JamDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement psiElement, int offsetInElement, @NotNull Consumer<PomTarget> consumer) {
        if (psiElement == null) {
            JamDeclarationSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JamDeclarationSearcher.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof PsiLanguageInjectionHost)) {
            return;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)psiElement;
        UExpression element = (UExpression)UastContextKt.toUElement((PsiElement)host, UExpression.class);
        if (element == null) {
            return;
        }
        if (JamReferenceContributor.STRING_IN_ANNO.accepts((Object)element, UastPatterns.withRequestedPsi((PsiElement)host)) && element.evaluate() instanceof String) {
            JamAttributeMeta attribute;
            Pair entry = UAnnotationUtils.getContainingAnnotationEntry((UElement)element);
            if (entry == null) {
                return;
            }
            PsiAnnotation anno = (PsiAnnotation)entry.getFirst();
            PsiElement member = anno.getParent().getParent();
            JamService service = JamService.getJamService((Project)anno.getProject());
            if (member instanceof PsiModifierListOwner) {
                PsiModifierListOwner owner = (PsiModifierListOwner)member;
                for (JamMemberMeta memberMeta : service.getMetas(owner)) {
                    JamElement jamElement = memberMeta.getJamElement(owner);
                    if (jamElement == null) continue;
                    JamDeclarationSearcher.addTargets(memberMeta.getAssociatedTargets(jamElement), consumer, host);
                }
                return;
            }
            PsiNameValuePair pair = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)anno, PsiNameValuePair.class);
            if (pair == null) {
                return;
            }
            PsiAnnotation superAnno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair, PsiAnnotation.class);
            if (superAnno == null) {
                return;
            }
            JamAnnotationMeta annotationMeta = service.getMeta(superAnno);
            if (annotationMeta != null && (attribute = annotationMeta.findAttribute(pair.getName())) instanceof JamAnnotationAttributeMeta) {
                JamAnnotationAttributeMeta meta = (JamAnnotationAttributeMeta)attribute;
                JamElement jamElement = service.getJamElement(JamService.JAM_ELEMENT_KEY, (PsiElement)anno);
                if (jamElement != null) {
                    JamDeclarationSearcher.addTargets(meta.getAssociatedTargets(jamElement), consumer, host);
                }
            }
        }
    }

    private static void addTargets(List<? extends PomTarget> list, Consumer<? super PomTarget> consumer, PsiLanguageInjectionHost psiLiteral) {
        for (PomTarget pomTarget : list) {
            if (!(pomTarget instanceof JamPomTarget) || !JamReferenceContributorKt.isJamElementFromHost((PsiAnnotationMemberValue)((JamPomTarget)pomTarget).getNameAttr().getPsiElement(), (PsiLanguageInjectionHost)psiLiteral)) continue;
            consumer.consume((Object)pomTarget);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/jam/JamDeclarationSearcher";
        objectArray[2] = "findDeclarationsAt";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

