/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamClassGenerator;
import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamAnnotation;
import com.intellij.jam.annotations.JamAttribute;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.proxy.AdvancedEnhancer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamClassGeneratorImpl
extends JamClassGenerator {
    private static final Logger LOG = Logger.getInstance(JamClassGeneratorImpl.class);
    private static final InvocationHandler DUMMY = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) {
            throw new UnsupportedOperationException("Method invoke is not yet implemented in " + this.getClass().getName());
        }
    };
    private static final MethodInterceptor EQUALS_HANDLER_CALL_SUPER = new MethodInterceptor(){

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (!((Boolean)proxy.invokeSuper(obj, args)).booleanValue()) {
                return false;
            }
            return EQUALS_HANDLER.invoke(obj, method, args);
        }
    };
    private static final InvocationHandler EQUALS_HANDLER = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) {
            Object arg = args[0];
            if (arg instanceof JamElement && arg instanceof Factory) {
                return JamClassGeneratorImpl.getReferenceHolder(proxy).equals(JamClassGeneratorImpl.getReferenceHolder(arg));
            }
            return false;
        }
    };
    private static final MethodInterceptor HASH_CODE_HANDLER_CALL_SUPER = new MethodInterceptor(){

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            int superCode = (Integer)proxy.invokeSuper(obj, args);
            return JamClassGeneratorImpl.getReferenceHolder(obj).hashCode() * 239 + superCode * 42;
        }
    };
    private static final MethodInterceptor HASH_CODE_HANDLER = new MethodInterceptor(){

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) {
            return JamClassGeneratorImpl.getReferenceHolder(obj).hashCode() * 239;
        }
    };
    private static final InvocationHandler PSI_REF_GETTER = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) {
            return JamClassGeneratorImpl.getPsiRef(proxy);
        }
    };
    private static final InvocationHandler PSI_ELEMENT_GETTER = new InvocationHandler(){

        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) {
            return JamClassGeneratorImpl.getPsiRef(proxy).getPsiElement();
        }
    };
    private static final InvocationHandler PSI_VALIDITY_GETTER = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) {
            return JamClassGeneratorImpl.getReferenceHolder(proxy).$$$isRefValid$$$();
        }
    };
    private static final MethodInterceptor TO_STRING = new MethodInterceptor(){

        @NonNls
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return proxy.invokeSuper(obj, args) + "[holder=" + JamClassGeneratorImpl.getReferenceHolder(obj) + "]";
        }
    };
    private static final InvocationHandler ATTRIBUTE_GETTER = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) {
            String annoQName = method.getAnnotation(JamAnnotation.class).value();
            String name = method.getAnnotation(JamAttribute.class).value();
            PsiElementRef memberRef = JamClassGeneratorImpl.getPsiRef(proxy);
            PsiElementRef annoRef = new AnnotationChildLink(annoQName).createChildRef(memberRef);
            Type returnType = method.getGenericReturnType();
            if (JamClassAttributeElement.class.equals((Object)returnType)) {
                return new JamClassAttributeMeta.Single(name).getJam(annoRef);
            }
            Type componentType = DomReflectionUtil.extractCollectionElementType((Type)returnType);
            if (JamClassAttributeElement.class.equals((Object)componentType)) {
                return new JamClassAttributeMeta.Collection(name).getJam(annoRef);
            }
            throw new UnsupportedOperationException();
        }
    };
    private static final Callback[] CALLBACKS = new Callback[]{DUMMY, NoOp.INSTANCE, EQUALS_HANDLER, EQUALS_HANDLER_CALL_SUPER, HASH_CODE_HANDLER, HASH_CODE_HANDLER_CALL_SUPER, PSI_REF_GETTER, PSI_ELEMENT_GETTER, ATTRIBUTE_GETTER, PSI_VALIDITY_GETTER, TO_STRING};
    private static final CallbackFilter CALLBACK_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            @NonNls String name = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if ("finalize".equals(name) && parameterTypes.length == 0) {
                return 1;
            }
            if ("toString".equals(name) && parameterTypes.length == 0) {
                return 10;
            }
            if ("equals".equals(name) && parameterTypes.length == 1 && Object.class.equals(parameterTypes[0])) {
                return Object.class.equals(method.getDeclaringClass()) ? 2 : 3;
            }
            if ("hashCode".equals(name) && parameterTypes.length == 0) {
                return Object.class.equals(method.getDeclaringClass()) ? 4 : 5;
            }
            if ((method.getModifiers() & 0x400) != 0) {
                if (method.getAnnotation(JamPsiConnector.class) != null) {
                    assert (parameterTypes.length == 0);
                    if (ReflectionUtil.isAssignable(PsiElementRef.class, method.getReturnType())) {
                        return 6;
                    }
                    assert (ReflectionUtil.isAssignable(PsiElement.class, method.getReturnType()));
                    return 7;
                }
                if (method.getAnnotation(JamAttribute.class) != null) {
                    Type genericReturnType = method.getGenericReturnType();
                    if (JamClassAttributeElement.class.equals((Object)genericReturnType)) {
                        return 8;
                    }
                    if (JamClassAttributeElement.class.equals((Object)DomReflectionUtil.extractCollectionElementType((Type)genericReturnType))) {
                        return 8;
                    }
                }
                if (method.getAnnotation(JamPsiValidity.class) != null) {
                    assert (parameterTypes.length == 0);
                    assert (method.getReturnType() == Boolean.TYPE);
                    return 9;
                }
                return 0;
            }
            return 1;
        }
    };

    public <T> NotNullFunction<PsiElementRef, T> generateJamElementFactory(final Class<T> base) {
        AtomicNotNullLazyValue<AdvancedEnhancer> enhancer = new AtomicNotNullLazyValue<AdvancedEnhancer>(){

            @NotNull
            protected AdvancedEnhancer compute() {
                AdvancedEnhancer advancedEnhancer = JamClassGeneratorImpl.createEnhancer(base);
                if (advancedEnhancer == null) {
                    12.$$$reportNull$$$0(0);
                }
                return advancedEnhancer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamClassGeneratorImpl$12", "compute"));
            }
        };
        Constructor<?> annoConstructor = null;
        Constructor<?> memberConstructor = null;
        Constructor<?> refConstructor = null;
        for (Constructor<?> constructor : base.getDeclaredConstructors()) {
            if (constructor.getParameterCount() == 0) {
                return arg_0 -> JamClassGeneratorImpl.lambda$generateJamElementFactory$0((AtomicNotNullLazyValue)enhancer, constructor, base, arg_0);
            }
            if (constructor.getParameterCount() != 1) continue;
            Class<?> argType = constructor.getParameterTypes()[0];
            if (ReflectionUtil.isAssignable(PsiAnnotation.class, argType)) {
                annoConstructor = constructor;
                continue;
            }
            if (ReflectionUtil.isAssignable(PsiModifierListOwner.class, argType)) {
                memberConstructor = constructor;
                continue;
            }
            if (!PsiElementRef.class.equals(argType)) continue;
            refConstructor = constructor;
        }
        if (refConstructor != null) {
            Constructor<?> finalRefConstructor = refConstructor;
            return arg_0 -> JamClassGeneratorImpl.lambda$generateJamElementFactory$1((AtomicNotNullLazyValue)enhancer, finalRefConstructor, base, arg_0);
        }
        return JamClassGeneratorImpl.instantiatorByPsiElement((AtomicNotNullLazyValue<? extends AdvancedEnhancer>)enhancer, annoConstructor, memberConstructor, base);
    }

    @NotNull
    private static AdvancedEnhancer createEnhancer(@NotNull Class base) {
        if (base == null) {
            JamClassGeneratorImpl.$$$reportNull$$$0(0);
        }
        AdvancedEnhancer enhancer = new AdvancedEnhancer();
        if (base.isInterface()) {
            enhancer.setInterfaces(new Class[]{base});
        } else {
            enhancer.setSuperclass(base);
        }
        enhancer.setCallbacks(CALLBACKS);
        enhancer.setCallbackFilter(CALLBACK_FILTER);
        enhancer.setClassLoader(base.getClassLoader());
        AdvancedEnhancer advancedEnhancer = enhancer;
        if (advancedEnhancer == null) {
            JamClassGeneratorImpl.$$$reportNull$$$0(1);
        }
        return advancedEnhancer;
    }

    private static <T> NotNullFunction<PsiElementRef, T> instantiatorByPsiElement(AtomicNotNullLazyValue<? extends AdvancedEnhancer> enhancer, Constructor annoConstructor, Constructor memberConstructor, Class base) {
        return ref -> {
            PsiElement element = ref.getPsiElement();
            LOG.assertTrue(element != null);
            if (element instanceof PsiAnnotation) {
                assert (annoConstructor != null) : "No <init>(PsiAnnotation) in " + base;
                return JamClassGeneratorImpl.createProxy(enhancer, ref, annoConstructor, base, element);
            }
            assert (memberConstructor != null) : "No <init>(PsiModifierListOwner) in " + base;
            return JamClassGeneratorImpl.createProxy(enhancer, ref, memberConstructor, base, element);
        };
    }

    private static Object createProxy(@NotNull AtomicNotNullLazyValue<? extends AdvancedEnhancer> value, @NotNull PsiElementRef ref, @NotNull Constructor constructor, @NotNull Class baseClass, Object ... arguments) {
        if (value == null) {
            JamClassGeneratorImpl.$$$reportNull$$$0(2);
        }
        if (ref == null) {
            JamClassGeneratorImpl.$$$reportNull$$$0(3);
        }
        if (constructor == null) {
            JamClassGeneratorImpl.$$$reportNull$$$0(4);
        }
        if (baseClass == null) {
            JamClassGeneratorImpl.$$$reportNull$$$0(5);
        }
        if (arguments == null) {
            JamClassGeneratorImpl.$$$reportNull$$$0(6);
        }
        try {
            Object o = ((AdvancedEnhancer)value.getValue()).create((Class[])constructor.getParameterTypes(), arguments);
            LOG.assertTrue(((Factory)o).getCallback(0) == DUMMY);
            ((Factory)o).getCallbacks();
            JamReferenceHolderImpl holder = new JamReferenceHolderImpl(baseClass, ref);
            ((Factory)o).setCallback(0, (Callback)holder);
            if (!(((Factory)o).getCallback(0) instanceof JamReferenceHolder)) {
                Object[] callbacks = ((Factory)o).getCallbacks();
                ((Factory)o).setCallback(0, (Callback)holder);
                throw new AssertionError((Object)("CCE: " + Arrays.toString(callbacks) + "; second: " + Arrays.toString(((Factory)o).getCallbacks())));
            }
            LOG.assertTrue(o.equals(o));
            LOG.assertTrue(o.hashCode() == o.hashCode());
            LOG.assertTrue(JamClassGeneratorImpl.getReferenceHolder(o) == holder);
            return o;
        }
        catch (CodeGenerationException e) {
            Throwable cause = e.getCause();
            ExceptionUtil.rethrowUnchecked((Throwable)cause);
            throw new RuntimeException(cause);
        }
    }

    private static PsiElementRef getPsiRef(Object jamProxy) {
        return JamClassGeneratorImpl.getReferenceHolder(jamProxy).$$$getPsiRef$$$();
    }

    private static JamReferenceHolder getReferenceHolder(Object jamProxy) {
        return (JamReferenceHolder)((Factory)jamProxy).getCallback(0);
    }

    private static /* synthetic */ Object lambda$generateJamElementFactory$1(AtomicNotNullLazyValue enhancer, Constructor finalRefConstructor, Class base, PsiElementRef ref) {
        return JamClassGeneratorImpl.createProxy((AtomicNotNullLazyValue<? extends AdvancedEnhancer>)enhancer, ref, finalRefConstructor, base, ref);
    }

    private static /* synthetic */ Object lambda$generateJamElementFactory$0(AtomicNotNullLazyValue enhancer, Constructor constructor, Class base, PsiElementRef ref) {
        return JamClassGeneratorImpl.createProxy((AtomicNotNullLazyValue<? extends AdvancedEnhancer>)enhancer, ref, constructor, base, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/JamClassGeneratorImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/JamClassGeneratorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnhancer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEnhancer";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createProxy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class JamReferenceHolderImpl
    implements InvocationHandler,
    JamReferenceHolder {
        private final Class myBaseClass;
        private final Object myRef;

        private JamReferenceHolderImpl(Class baseClass, PsiElementRef ref) {
            this.myBaseClass = baseClass;
            this.myRef = ref.isImaginary() ? ref : PsiAnchor.create((PsiElement)Objects.requireNonNull(ref.getPsiElement()));
        }

        @Override
        public PsiElementRef $$$getPsiRef$$$() {
            if (this.myRef instanceof PsiElementRef) {
                return (PsiElementRef)this.myRef;
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiElement target = ((PsiAnchor)this.myRef).retrieve();
            if (target == null) {
                String message = "Anchor hasn't survived: " + this.myRef;
                if (this.myRef instanceof PsiAnchor.StubIndexReference) {
                    message = message + "; diagnostics=" + ((PsiAnchor.StubIndexReference)this.myRef).diagnoseNull();
                }
                throw new PsiInvalidElementAccessException(null, message);
            }
            return PsiElementRef.real((PsiElement)target);
        }

        @Override
        public boolean $$$isRefValid$$$() {
            if (this.myRef instanceof PsiElementRef) {
                return ((PsiElementRef)this.myRef).isValid();
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            return ((PsiAnchor)this.myRef).retrieve() != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JamReferenceHolderImpl)) {
                return false;
            }
            JamReferenceHolderImpl that = (JamReferenceHolderImpl)o;
            if (!this.myBaseClass.equals(that.myBaseClass)) {
                return false;
            }
            return this.myRef.equals(that.myRef);
        }

        public int hashCode() {
            int result = this.myBaseClass.hashCode();
            result = 31 * result + this.myRef.hashCode();
            return result;
        }

        @NonNls
        public String toString() {
            return "JamReferenceHolderImpl{myBaseClass=" + this.myBaseClass + ", myRef=" + this.myRef + "}";
        }

        public Object invoke(Object proxy, Method method, Object[] args) {
            throw new UnsupportedOperationException("Method invoke is not yet implemented in " + this.getClass().getName());
        }
    }

    private static interface JamReferenceHolder {
        public PsiElementRef $$$getPsiRef$$$();

        public boolean $$$isRefValid$$$();
    }
}

