/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph;

import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import org.gga.graph.Edge;
import org.gga.graph.Graph;
import org.gga.graph.impl.DataGraphImpl;
import org.gga.graph.impl.SparseGraphImpl;
import org.gga.graph.maps.DataGraph;
import org.gga.graph.util.IntBooleanFunction;

public final class Subgraph {
    private Subgraph() {
    }

    public static Pair<Graph, int[]> subgraph(Graph g, boolean[] verticesToInclude) {
        int newSize = 0;
        int[] verticesMap = new int[g.V()];
        Arrays.fill(verticesMap, -1);
        for (int i = 0; i < verticesToInclude.length; ++i) {
            boolean b = verticesToInclude[i];
            if (!b) continue;
            verticesMap[i] = newSize++;
        }
        SparseGraphImpl result = new SparseGraphImpl(newSize, g.isDirected());
        for (int v = 0; v < g.V(); ++v) {
            if (!verticesToInclude[v]) continue;
            Iterator<Edge> i = g.getEdges(v);
            while (i.hasNext()) {
                Edge e = i.next();
                if (!verticesToInclude[e.w()]) continue;
                result.insert(verticesMap[e.v()], verticesMap[e.w()]);
            }
        }
        return new Pair((Object)result, (Object)verticesMap);
    }

    public static Pair<Graph, int[]> subgraph(Graph g, IntBooleanFunction memberFunction) {
        boolean[] verticesToInclude = new boolean[g.V()];
        for (int v = 0; v < g.V(); ++v) {
            verticesToInclude[v] = memberFunction.fun(v);
        }
        return Subgraph.subgraph(g, verticesToInclude);
    }

    public static <N, E> Pair<DataGraph<N, E>, int[]> subgraph(DataGraph<N, E> g, Predicate<? super N> memberFunction) {
        return Subgraph.subgraph(g, memberFunction, null);
    }

    public static <N, E> Pair<DataGraph<N, E>, int[]> subgraph(DataGraph<N, E> g, Predicate<? super N> nodeMemberFunction, Predicate<? super Edge> edgeMemberFunction) {
        return Subgraph.subgraph(g, nodeMemberFunction, edgeMemberFunction, DataGraph.Implementation.SPARSE);
    }

    public static <N, E> Pair<DataGraph<N, E>, int[]> subgraph(DataGraph<N, E> g, Predicate<? super N> nodeMemberFunction, Predicate<? super Edge> edgeMemberFunction, DataGraph.Implementation implementation) {
        int v;
        int newSize = 0;
        int[] verticesMap = new int[g.V()];
        Arrays.fill(verticesMap, -1);
        for (int i = 0; i < verticesMap.length; ++i) {
            boolean b = nodeMemberFunction.test(g.getNode(i));
            if (!b) continue;
            verticesMap[i] = newSize++;
        }
        DataGraphImpl result = new DataGraphImpl(newSize, g.isDirected(), implementation);
        for (v = 0; v < g.V(); ++v) {
            if (verticesMap[v] < 0) continue;
            result.setNode(verticesMap[v], g.getNode(v));
        }
        for (v = 0; v < g.V(); ++v) {
            if (verticesMap[v] < 0) continue;
            Iterator<Edge> i = g.getIntGraph().getEdges(v);
            while (i.hasNext()) {
                Edge e = i.next();
                if (verticesMap[e.w()] < 0 || edgeMemberFunction != null && !edgeMemberFunction.test(e)) continue;
                result.insert(result.getNode(verticesMap[e.v()]), result.getNode(verticesMap[e.w()]), g.edge(g.getNode(e.v()), g.getNode(e.w())));
            }
        }
        return new Pair(result, (Object)verticesMap);
    }
}

