/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.SelectionVisitor;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;

class PaintSelection0Visitor<N>
implements SelectionVisitor<N> {
    protected Graphics2D g;
    protected DsmTableImpl<N> myDsmTable;

    PaintSelection0Visitor(DsmTableImpl<N> dsmTable, Graphics2D g) {
        this.myDsmTable = dsmTable;
        this.g = g;
    }

    @Override
    public final void visitRowSelection(DsmSelection<N> selection) {
        for (DsmTreeStructure.TreeNode node : selection.node1) {
            Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node));
            assert (r != null);
            this.g.setPaint(UIUtil.getTreeSelectionBackground((boolean)this.myDsmTable.isFocusOwner()));
            this.g.fillRect(0, r.y, this.myDsmTable.myCache.myTableSize, r.height);
            this.g.fillRect(r.y, 0, r.height, this.myDsmTable.myCache.myTableSize);
        }
    }

    @Override
    public void visitCellSelection(DsmSelection<N> selection) {
        int y11 = Integer.MAX_VALUE;
        int y12 = -1;
        int y21 = Integer.MAX_VALUE;
        int y22 = -1;
        for (DsmTreeStructure.TreeNode node1 : selection.node1) {
            for (DsmTreeStructure.TreeNode node2 : selection.node2) {
                Rectangle r1 = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node1));
                Rectangle r2 = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node2));
                assert (r1 != null);
                assert (r2 != null);
                y11 = Math.min(y11, r1.y);
                y12 = Math.max(y12, r1.y + r1.height);
                y21 = Math.min(y21, r2.y);
                y22 = Math.max(y22, r2.y + r2.height);
            }
        }
        assert (y12 >= 0);
        assert (y11 < Integer.MAX_VALUE);
        assert (y22 >= 0);
        assert (y21 < Integer.MAX_VALUE);
        this.g.setPaint(DsmTableConstants.COLOR_BCK_DEP);
        this.g.fillRect(y11, 0, y12 - y11, this.myDsmTable.myCache.myTableSize);
        this.g.fillRect(0, y11, this.myDsmTable.myCache.myTableSize, y12 - y11);
        this.g.setPaint(DsmTableConstants.COLOR_FWD_DEP);
        this.g.fillRect(y21, 0, y22 - y21, this.myDsmTable.myCache.myTableSize);
        this.g.fillRect(0, y21, this.myDsmTable.myCache.myTableSize, y22 - y21);
        this.g.setPaint(DsmTableConstants.COLOR_CRS_DEP);
        this.g.fillRect(y21, y11, y22 - y21, y12 - y11);
        this.g.fillRect(y11, y21, y12 - y11, y22 - y21);
    }
}

