/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.gga.graph.maps.DataGraph;

public abstract class AbstractDsmTreeStructure<N>
implements DsmTreeStructure<N> {
    protected final DataGraph<N, Integer> myGraph;
    private final List<DsmTreeStructure.TreeStructureListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private DsmTreeStructure.TreeNode<N> myRootNode;

    protected AbstractDsmTreeStructure(DataGraph<N, Integer> graph) {
        this.myGraph = graph;
    }

    @Override
    public DataGraph<N, Integer> getGraph() {
        return this.myGraph;
    }

    @Override
    public void addTreeStructureListener(DsmTreeStructure.TreeStructureListener listener) {
        this.myListeners.add(listener);
    }

    protected void fireTreeStructureChanged() {
        this.fireBeforeTreeStructureChange();
        this.resetTreeStructure();
        this.fireAfterTreeStructureChange();
    }

    void resetTreeStructure() {
        this.myRootNode = null;
    }

    void fireAfterTreeStructureChange() {
        for (DsmTreeStructure.TreeStructureListener listener : this.myListeners) {
            listener.afterTreeStructureChanged();
        }
    }

    void fireBeforeTreeStructureChange() {
        for (DsmTreeStructure.TreeStructureListener listener : this.myListeners) {
            listener.beforeTreeStructureChanged();
        }
    }

    protected abstract DsmTreeStructure.TreeNode<N> createRoot();

    @Override
    public DsmTreeStructure.TreeNode<N> getRootNode() {
        if (this.myRootNode == null) {
            this.myRootNode = this.createRoot();
        }
        return this.myRootNode;
    }
}

