/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.dsm.actions.AbstractDsmAction;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.model.classes.DsmPsiNode;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OpenInEditorAction<N extends DsmPsiNode>
extends AbstractDsmAction<N>
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenInEditorAction.$$$reportNull$$$0(0);
        }
        Collection selections = this.getSelection(e);
        DsmSelection s = selections.iterator().next();
        DsmTreeStructure.TreeNode node = s.node1.iterator().next();
        PsiElement element = ((DsmPsiNode)node.getLeafData()).getElement();
        if (element == null) {
            return;
        }
        Project project = element.getProject();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, element.getContainingFile().getVirtualFile(), element.getTextOffset());
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        Collection selections = this.getSelection(e);
        if (selections.size() != 1) {
            return false;
        }
        DsmSelection s = selections.iterator().next();
        if (s.type != DsmSelection.Type.ROW) {
            return false;
        }
        Set nodes = s.node1;
        if (nodes.size() > 1) {
            return false;
        }
        DsmTreeStructure.TreeNode node = s.node1.iterator().next();
        if (!node.isLeaf()) {
            return false;
        }
        if (!DsmPsiNode.class.isAssignableFrom(this.getModel(e).getNodeClass())) {
            return false;
        }
        return ((DsmPsiNode)node.getLeafData()).getElement() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dsm/actions/OpenInEditorAction", "actionPerformed"));
    }
}

