/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.text.ElementPresentation;

public class TextFragmentType
implements CodeFragmentType {
    private final RangeMarker myRangeMarker;
    private final PsiClass myEnclosingClass;

    public TextFragmentType(PsiClass enclosingClass, RangeMarker rangeMarker) {
        this.myEnclosingClass = enclosingClass;
        this.myRangeMarker = rangeMarker;
    }

    public CompositeAppearance getTitle(boolean selected) {
        ElementPresentation classPresentation;
        Document document = this.myRangeMarker.getDocument();
        int startingLine = document.getLineNumber(this.myRangeMarker.getStartOffset()) + 1;
        int endingLine = document.getLineNumber(this.myRangeMarker.getEndOffset()) + 1;
        if (this.myEnclosingClass == null || this.myEnclosingClass instanceof PsiSyntheticClass) {
            classPresentation = ElementPresentation.forVirtualFile((VirtualFile)FileDocumentManager.getInstance().getFile(this.myRangeMarker.getDocument()));
        } else {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myEnclosingClass, PsiClass.class, (boolean)false);
            classPresentation = ElementPresentation.forElement((PsiElement)psiClass);
        }
        String fragmentInfo = startingLine == endingLine ? DupLocatorBundle.message((String)"duplicate.location.single.line", (Object[])new Object[]{startingLine, classPresentation.getName()}) : DupLocatorBundle.message((String)"duplicate.location.multiple.lines", (Object[])new Object[]{startingLine, endingLine, classPresentation.getName()});
        CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
        ending.addText(fragmentInfo, BasicTreeNode.getTextAttributes((boolean)selected));
        ending.addComment(classPresentation.getComment(), BasicTreeNode.getCommentAttributes((boolean)selected));
        CompositeAppearance appearance = ending.getAppearance();
        appearance.setIcon(IconUtil.getEmptyIcon((boolean)false));
        return appearance;
    }
}

