/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Fail;
import org.fest.assertions.GenericAssert;

public abstract class ComparableAssert<S, T extends Comparable<T>>
extends GenericAssert<S, T> {
    protected ComparableAssert(@Nonnull Class<S> selfType, @Nullable T actual) {
        super(selfType, actual);
    }

    @Nonnull
    public final S isEqualByComparingTo(T expected) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(expected) == 0) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw Fail.comparisonFailed(this.rawDescription(), this.actual, expected);
    }

    @Nonnull
    public final S isNotEqualByComparingTo(T expected) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(expected) != 0) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, expected));
    }

    @Nonnull
    public final S isLessThan(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) < 0) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public final S isGreaterThan(@Nullable T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) > 0) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public final S isLessThanOrEqualTo(@Nullable T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) <= 0) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Nonnull
    public final S isGreaterThanOrEqualTo(@Nullable T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) >= 0) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }
}

