/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webClient.restOperations;

import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.functional.webClient.WebClientHolder;
import com.intellij.spring.functional.webClient.WebClientUrl;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.spring.webClient.restOperations.RestOperationsUtils;
import com.intellij.spring.webClient.restOperations.RestTemplateFramework;
import com.intellij.spring.webClient.restOperations.TestRestTemplateModel;
import icons.SpringApiIcons;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spring/webClient/restOperations/TestRestTemplateFramework;", "Lcom/intellij/spring/webClient/restOperations/RestTemplateFramework;", "()V", "myHoldersSearcher", "Lcom/intellij/microservices/cache/SourceTestLibSearcher;", "Lcom/intellij/spring/functional/webClient/WebClientHolder;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "Lcom/intellij/spring/functional/webClient/WebClientUrl;", "group", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "intellij.spring.mvc.impl"})
public final class TestRestTemplateFramework
extends RestTemplateFramework {
    private final SourceTestLibSearcher<WebClientHolder> myHoldersSearcher = new SourceTestLibSearcher("SPRING_TEST_REST_TEMPLATE", (Function2)new Function2<Module, GlobalSearchScope, List<? extends WebClientHolder>>(TestRestTemplateModel.INSTANCE){

        @NotNull
        public final List<WebClientHolder> invoke(@NotNull Module p1, @NotNull GlobalSearchScope p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            return ((TestRestTemplateModel)this.receiver).findHolders(p1, p2);
        }
    });
    @NotNull
    private final FrameworkPresentation presentation;

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!RestOperationsUtils.isTestRestTemplateAvailable(project)) {
            return EndpointsProvider.Status.UNAVAILABLE;
        }
        if (TestRestTemplateModel.INSTANCE.hasUsages(project)) {
            return EndpointsProvider.Status.HAS_ENDPOINTS;
        }
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public Iterable<WebClientHolder> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!RestOperationsUtils.isTestRestTemplateAvailable(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.myHoldersSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<WebClientUrl> getEndpoints(@NotNull WebClientHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return TestRestTemplateModel.INSTANCE.getEndpoints(group);
    }

    public TestRestTemplateFramework() {
        String string = SpringMvcBundle.message("spring.test.rest.template.endpoints.view.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpringMvcBundle.message(\u2026te.endpoints.view.title\")");
        this.presentation = new FrameworkPresentation("Spring-TestRestTemplate", string, SpringApiIcons.SpringWeb);
    }
}

