/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views.resolvers;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.web.mvc.views.ViewResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class ResourceBundleViewResolver
extends ViewResolver {
    private final Set<String> myBasenames;
    private final CommonSpringBean myBean;

    public ResourceBundleViewResolver(@NotNull CommonSpringBean commonSpringBean) {
        if (commonSpringBean == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(0);
        }
        this.myBasenames = new LinkedHashSet<String>();
        this.myBean = commonSpringBean;
        if (commonSpringBean instanceof SpringBean) {
            SpringBean bean = (SpringBean)commonSpringBean;
            String basename = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"basename");
            if (basename != null) {
                this.myBasenames.add(basename);
            } else {
                Set basenames = SpringPropertyUtils.getArrayPropertyStringValues((CommonSpringBean)bean, (String)"basenames");
                if (basenames.size() > 0) {
                    this.myBasenames.addAll(basenames);
                } else {
                    this.myBasenames.add("views");
                }
            }
        }
    }

    @NotNull
    @TestOnly
    public String getID() {
        String string = "ResourceBundleViewResolver[" + this.myBean.getBeanName() + "]";
        if (string == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Set<PsiElement> resolveView(String viewName) {
        List<PropertiesFile> bundles = this.getBundles();
        for (PropertiesFile bundle : bundles) {
            IProperty property = bundle.findPropertyByKey(viewName);
            if (property == null) continue;
            Set<PsiElement> set = Collections.singleton(property.getPsiElement());
            if (set == null) {
                ResourceBundleViewResolver.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public List<LookupElement> getAllResolverViews() {
        ArrayList<LookupElement> list = new ArrayList<LookupElement>();
        List<PropertiesFile> bundles = this.getBundles();
        for (PropertiesFile bundle : bundles) {
            for (IProperty property : bundle.getProperties()) {
                String key = property.getKey();
                if (key == null) continue;
                list.add((LookupElement)LookupElementBuilder.create((String)key).withTailText(" (" + property.getValue() + ")", true));
            }
        }
        ArrayList<LookupElement> arrayList = list;
        if (arrayList == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public String bindToElement(PsiElement element) {
        return ((IProperty)element).getKey();
    }

    @NotNull
    public String handleElementRename(String newElementName) {
        String string = newElementName;
        if (string == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(5);
        }
        return string;
    }

    private List<PropertiesFile> getBundles() {
        PsiFile containingFile = this.myBean.getContainingFile();
        ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)containingFile.getProject());
        for (String basename : this.myBasenames) {
            String text = basename + ".properties";
            PsiFileImpl file = (PsiFileImpl)factory.createFileFromText("foo.txt", text);
            file.setOriginalFile(containingFile);
            PsiReference[] references = new FilePathReferenceProvider().getReferencesByElement((PsiElement)file, text, 0, false);
            PsiFileSystemItem item = ((FileReference)references[0]).getFileReferenceSet().resolve();
            if (!(item instanceof PropertiesFile)) continue;
            files.add((PropertiesFile)item);
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSpringBean";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/views/resolvers/ResourceBundleViewResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/views/resolvers/ResourceBundleViewResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResolverViews";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

