/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SpringMvcView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SpringMvcViewSettings
implements PersistentStateComponent<Settings> {
    private final Settings mySettings = new Settings();
    public static final Topic<Listener> TOPIC = new Topic("Spring MVC View settings", Listener.class);

    public static void fireSettingsChanged(Project project, ChangeType changeType) {
        ((Listener)project.getMessageBus().syncPublisher(TOPIC)).settingsChanged(changeType);
    }

    public static SpringMvcViewSettings getInstance(Project project) {
        return (SpringMvcViewSettings)ServiceManager.getService((Project)project, SpringMvcViewSettings.class);
    }

    @Nullable
    public Settings getState() {
        return this.mySettings;
    }

    public void loadState(@NotNull Settings settings) {
        if (settings == null) {
            SpringMvcViewSettings.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)settings, (Object)this.mySettings);
    }

    public boolean isShowModules() {
        return this.mySettings.showModules;
    }

    public void setShowModules(boolean value) {
        this.mySettings.showModules = value;
    }

    public boolean isShowDoc() {
        return this.mySettings.showDoc;
    }

    public void setShowDoc(boolean value) {
        this.mySettings.showDoc = value;
    }

    public boolean isShowControllers() {
        return this.mySettings.showControllers;
    }

    public void setShowControllers(boolean value) {
        this.mySettings.showControllers = value;
    }

    public Set<RequestMethod> getRequestMethods() {
        return this.mySettings.requestMethods;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/web/mvc/toolWindow/SpringMvcViewSettings", "loadState"));
    }

    public static class Settings {
        public boolean showModules = true;
        public boolean showControllers = true;
        public boolean showDoc = true;
        public Set<RequestMethod> requestMethods = EnumSet.allOf(RequestMethod.class);
    }

    public static enum ChangeType {
        FULL,
        UPDATE_LIST,
        UPDATE_DETAILS,
        REPLACE_CHILD_UPDATE;

    }

    public static interface Listener {
        public void settingsChanged(ChangeType var1);
    }
}

