/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.ide.SelectInContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.mvc.ViewControllerBase;
import com.intellij.spring.web.mvc.SpringControllerUtils;
import com.intellij.spring.web.mvc.mapping.UrlMappingElement;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewSettings;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

class SpringMvcViewSelectInTargetPathBuilder {
    private Object[] myPath = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    private Module myModule;
    private SpringMvcViewSettings myViewSettings;

    SpringMvcViewSelectInTargetPathBuilder(SelectInContext context) {
        PsiElement element = this.getElement(context);
        if (element != null) {
            this.calculatePath(element);
        }
    }

    boolean canSelect() {
        return this.myPath.length != 0;
    }

    Object[] getPath() {
        return this.myPath;
    }

    private PsiElement getElement(SelectInContext context) {
        Object selector = context.getSelectorInFile();
        if (!(selector instanceof PsiElement)) {
            return null;
        }
        PsiElement element = (PsiElement)selector;
        this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (this.myModule == null) {
            return null;
        }
        this.myViewSettings = SpringMvcViewSettings.getInstance(this.myModule.getProject());
        return element;
    }

    private void calculatePath(PsiElement element) {
        PsiClass psiClass;
        UClass uClass = (UClass)UastUtils.findContaining((PsiElement)element, UClass.class);
        PsiClass psiClass2 = psiClass = uClass != null ? uClass.getJavaPsi() : null;
        if (psiClass != null) {
            this.findControllerCode(element, psiClass);
        } else {
            this.findControllerXml(element);
        }
    }

    private void findControllerCode(PsiElement element, final PsiClass psiClass) {
        boolean isValidRequestMethod;
        if (psiClass.hasModifierProperty("private") || PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
            return;
        }
        if (!SpringControllerUtils.isController(psiClass)) {
            return;
        }
        CommonProcessors.FindProcessor<SpringBeanPointer> processor = new CommonProcessors.FindProcessor<SpringBeanPointer>(){

            protected boolean accept(SpringBeanPointer pointer) {
                return psiClass.equals(pointer.getBeanClass());
            }
        };
        if (SpringMvcViewUtils.processControllers(this.myModule, (Processor<? super SpringBeanPointer>)processor)) {
            for (Module dependentModule : ModuleUtilCore.getAllDependentModules((Module)this.myModule)) {
                if (SpringMvcViewUtils.processControllers(dependentModule, (Processor<? super SpringBeanPointer>)processor)) continue;
                this.myModule = dependentModule;
                break;
            }
        }
        if (!processor.isFound()) {
            return;
        }
        SpringBeanPointer controllerSpringBeanPointer = (SpringBeanPointer)processor.getFoundValue();
        UMethod uMethod = (UMethod)UastUtils.findContaining((PsiElement)element, UMethod.class);
        final PsiMethod requestMethod = uMethod != null ? uMethod.getJavaPsi() : null;
        UrlMappingElement requestMappingItem = null;
        boolean bl = isValidRequestMethod = requestMethod != null && SpringControllerUtils.isRequestHandler(requestMethod);
        if (isValidRequestMethod) {
            CommonProcessors.FindProcessor<UrlMappingElement> methodProcessor = new CommonProcessors.FindProcessor<UrlMappingElement>(){

                protected boolean accept(UrlMappingElement variant) {
                    return requestMethod.equals(variant.getNavigationTarget());
                }
            };
            requestMappingItem = this.findRequestMappingItem(controllerSpringBeanPointer, methodProcessor);
        }
        this.createResult(controllerSpringBeanPointer, requestMappingItem);
    }

    private void findControllerXml(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (!(file instanceof XmlFile)) {
            return;
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) {
            return;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (xmlTag == null) {
            return;
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)xmlTag);
        if (domElement == null) {
            return;
        }
        ViewControllerBase viewController = (ViewControllerBase)domElement.getParentOfType(ViewControllerBase.class, false);
        if (viewController == null) {
            return;
        }
        SpringBeanPointer controllerSpringBeanPointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)viewController);
        final String viewControllerPath = StringUtil.trimLeading((String)Objects.requireNonNull(viewController.getPath().getStringValue()), (char)'/');
        CommonProcessors.FindProcessor<UrlMappingElement> methodProcessor = new CommonProcessors.FindProcessor<UrlMappingElement>(){

            protected boolean accept(UrlMappingElement variant) {
                return variant.getURL().equals(viewControllerPath);
            }
        };
        UrlMappingElement requestMappingItem = this.findRequestMappingItem(controllerSpringBeanPointer, methodProcessor);
        this.createResult(controllerSpringBeanPointer, requestMappingItem);
    }

    @Nullable
    private UrlMappingElement findRequestMappingItem(SpringBeanPointer controllerSpringBeanPointer, CommonProcessors.FindProcessor<UrlMappingElement> processor) {
        SpringMvcViewUtils.processUrls(this.myModule, controllerSpringBeanPointer, this.myViewSettings.getRequestMethods(), processor);
        UrlMappingElement foundVariant = (UrlMappingElement)processor.getFoundValue();
        if (foundVariant == null) {
            return null;
        }
        return foundVariant;
    }

    private void createResult(SpringBeanPointer controllerSpringBeanPointer, @Nullable UrlMappingElement requestMappingItem) {
        SmartList pathValues = new SmartList();
        if (this.myViewSettings.isShowModules()) {
            pathValues.add(this.myModule);
        }
        if (this.myViewSettings.isShowControllers()) {
            pathValues.add(controllerSpringBeanPointer);
        }
        if (requestMappingItem != null) {
            pathValues.add(requestMappingItem);
        }
        this.myPath = ArrayUtil.toObjectArray((Collection)pathValues);
    }
}

