/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.mapping.UrlMappingElement;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewSettings;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewUtils;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import icons.SpringApiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcRequestMappingsPanel
extends FinderRecursivePanel<UrlMappingElement> {
    private final Set<Module> myModules;
    @Nullable
    private SpringBeanPointer myControllerSpringBeanPointer;

    public SpringMvcRequestMappingsPanel(@NotNull Project project, @Nullable String groupId) {
        if (project == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(0);
        }
        super(project, groupId);
        this.myModules = new HashSet<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!SpringMvcRequestMappingsPanel.isRelevantModule(module)) continue;
            this.myModules.add(module);
        }
    }

    public SpringMvcRequestMappingsPanel(@NotNull FinderRecursivePanel parent, Module module) {
        if (parent == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(1);
        }
        super(parent);
        this.myModules = SpringMvcRequestMappingsPanel.getRelevantModules(module);
    }

    public SpringMvcRequestMappingsPanel(FinderRecursivePanel<SpringBeanPointer> parent, @NotNull SpringBeanPointer controllerSpringBeanPointer) {
        if (controllerSpringBeanPointer == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(2);
        }
        super(parent);
        PsiFile myControllerFile = controllerSpringBeanPointer.getContainingFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)myControllerFile);
        this.myModules = SpringMvcRequestMappingsPanel.getRelevantModules(module);
        this.myControllerSpringBeanPointer = controllerSpringBeanPointer;
    }

    private static Set<Module> getRelevantModules(Module module) {
        HashSet<Module> modules = new HashSet<Module>();
        ModuleUtilCore.visitMeAndDependentModules((Module)module, module1 -> {
            if (SpringMvcRequestMappingsPanel.isRelevantModule(module1)) {
                modules.add(module1);
            }
            return true;
        });
        return modules;
    }

    private static boolean isRelevantModule(Module module) {
        return SpringCommonUtils.hasSpringFacet((Module)module);
    }

    @NotNull
    protected List<UrlMappingElement> getListItems() {
        ArrayList<UrlMappingElement> items = new ArrayList<UrlMappingElement>();
        Set<RequestMethod> requestMethods = SpringMvcViewSettings.getInstance(this.getProject()).getRequestMethods();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(items);
        for (Module module : this.myModules) {
            if (!SpringMvcViewUtils.processUrls(module, this.myControllerSpringBeanPointer, requestMethods, (Processor<? super UrlMappingElement>)processor)) break;
        }
        items.sort((item, item2) -> item.getPresentation().compareToIgnoreCase(item2.getPresentation()));
        ArrayList<UrlMappingElement> arrayList = items;
        if (arrayList == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    protected void doCustomizeCellRenderer(@NotNull SimpleColoredComponent comp, @NotNull JList list, @NotNull UrlMappingElement value, int index, boolean selected, boolean hasFocus) {
        String requestMethodPresentation;
        String containingFileName;
        if (comp == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(4);
        }
        if (list == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(5);
        }
        if (value == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(6);
        }
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        comp.append(UrlMappingElement.getPathPresentation((UrlMappingElement)value), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myControllerSpringBeanPointer == null && (containingFileName = UrlMappingElement.getContainingFileName((UrlMappingElement)value)) != null) {
            comp.append(" (" + containingFileName + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if ((requestMethodPresentation = UrlMappingElement.getRequestMethodPresentation((UrlMappingElement)value)) != null) {
            comp.append(" " + requestMethodPresentation, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    @NotNull
    protected String getItemText(@NotNull UrlMappingElement item) {
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(7);
        }
        String string = UrlMappingElement.getPathPresentation((UrlMappingElement)item) + " " + StringUtil.notNullize((String)UrlMappingElement.getContainingFileName((UrlMappingElement)item)) + " " + StringUtil.notNullize((String)UrlMappingElement.getRequestMethodPresentation((UrlMappingElement)item));
        if (string == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(@NotNull UrlMappingElement item) {
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(9);
        }
        return SpringApiIcons.RequestMapping;
    }

    protected boolean hasChildren(@NotNull UrlMappingElement item) {
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Nullable
    protected VirtualFile getContainingFile(@NotNull UrlMappingElement item) {
        PsiElement psiElement;
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(11);
        }
        return (psiElement = item.getNavigationTarget()) == null ? null : psiElement.getContainingFile().getVirtualFile();
    }

    protected boolean performEditAction() {
        UrlMappingElement value = (UrlMappingElement)this.getSelectedValue();
        if (value == null) {
            return true;
        }
        PsiElement element = value.getNavigationTarget();
        if (element != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element);
        }
        return true;
    }

    protected JComponent createDefaultRightComponent() {
        if (!this.isShowDoc()) {
            return null;
        }
        return super.createDefaultRightComponent();
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull UrlMappingElement item) {
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(12);
        }
        if (!this.isShowDoc()) {
            return null;
        }
        FinderRecursivePanel.DisposablePanel panel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        PsiElement element = item.getDocumentationPsiElement();
        if (element == null || this.isDisposed()) {
            return panel;
        }
        DocumentationComponent documentationComponent = DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)element, (Disposable)panel);
        panel.add((Component)documentationComponent, (Object)"Center");
        return panel;
    }

    private boolean isShowDoc() {
        return SpringMvcViewSettings.getInstance(this.getProject()).isShowDoc();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerSpringBeanPointer";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/toolWindow/SpringMvcRequestMappingsPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/toolWindow/SpringMvcRequestMappingsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCustomizeCellRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

