/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.thymeleaf;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.thymeleaf.references.paths.ThymeleafTemplateResolverMethodsSearchHelper;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafViewResolverFactory
extends ViewResolverFactory {
    private static final String[] ourResolvers = new String[]{"org.thymeleaf.spring3.view.ThymeleafViewResolver", "org.thymeleaf.spring4.view.ThymeleafViewResolver"};
    private static final String VIEW_RESOLVER_ID = "thymeleaf";

    protected boolean isMine(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(0);
        }
        for (String resolverClass : ourResolvers) {
            if (!((Boolean)ReadAction.compute(() -> InheritanceUtil.isInheritor((PsiClass)beanClass, (String)resolverClass))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public String getBeanClass() {
        return null;
    }

    @NotNull
    public Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        Module module;
        assert (bean != null);
        Module module2 = module = model.getModule() != null ? model.getModule() : bean.getModule();
        if (module == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                ThymeleafViewResolverFactory.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<ViewResolver> resolvers = new HashSet<ViewResolver>();
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        PsiClass templateResolverClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.thymeleaf.templateresolver.ITemplateResolver", moduleScope);
        if (templateResolverClass == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                ThymeleafViewResolverFactory.$$$reportNull$$$0(2);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)templateResolverClass).withInheritors();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (!configurers.isEmpty()) {
            if (bean instanceof SpringBean) {
                resolvers.addAll(this.getTemplateResolvers((SpringBean)bean));
            } else {
                for (SpringBeanPointer templateResolver : configurers) {
                    ViewResolver viewResolver = ThymeleafViewResolverFactory.createURLBasedViewResolver(module, templateResolver);
                    resolvers.add(viewResolver);
                }
            }
        } else {
            PsiFile file = bean.getContainingFile();
            if (file instanceof PsiJavaFile) {
                resolvers.addAll(ThymeleafViewResolverFactory.getConfiguredViewResolvers("org.thymeleaf.templateresolver.TemplateResolver", module, (SearchScope)GlobalSearchScope.fileScope((PsiFile)file)));
            }
        }
        HashSet<ViewResolver> hashSet = resolvers;
        if (hashSet == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private static Set<ViewResolver> getConfiguredViewResolvers(@NotNull String resolverClass, @NotNull Module module, @NotNull SearchScope scope) {
        if (resolverClass == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(4);
        }
        if (module == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(6);
        }
        HashSet<ViewResolver> resolvers = new HashSet<ViewResolver>();
        PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(resolverClass, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        for (Pair pair : ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixExpressions((PsiClass)aClass, (String)"setPrefix", (SearchScope)scope)) {
            String prefix = (String)pair.second;
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)pair.getFirst()), PsiMethod.class);
            if (psiMethod == null) continue;
            Set suffixes = ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixes((PsiClass)aClass, (String)"setSuffix", (SearchScope)new LocalSearchScope((PsiElement)psiMethod));
            if (suffixes.isEmpty()) {
                ViewResolver viewResolver = ThymeleafViewResolverFactory.createURLBasedViewResolver(module, "", prefix);
                resolvers.add(viewResolver);
                continue;
            }
            resolvers.addAll(suffixes.stream().map(suffix -> ThymeleafViewResolverFactory.createURLBasedViewResolver(module, suffix, prefix)).collect(Collectors.toList()));
        }
        HashSet<ViewResolver> hashSet = resolvers;
        if (hashSet == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public Set<ViewResolver> getTemplateResolvers(@NotNull SpringBean bean) {
        CommonSpringBean templateEngine;
        SpringBeanPointer templateEngineBean;
        if (bean == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(8);
        }
        HashSet<ViewResolver> resolvers = new HashSet<ViewResolver>();
        SpringPropertyDefinition property = bean.getProperty("templateEngine");
        Module module = bean.getModule();
        if (property instanceof SpringProperty && (templateEngineBean = (SpringBeanPointer)((SpringProperty)property).getRefAttr().getValue()) != null && (templateEngine = templateEngineBean.getSpringBean()) instanceof SpringBean) {
            SpringPropertyDefinition templateResolversProperty;
            SpringBeanPointer templateResolver2;
            SpringPropertyDefinition templateResolverProperty = ((SpringBean)templateEngine).getProperty("templateResolver");
            if (templateResolverProperty instanceof SpringProperty && (templateResolver2 = templateResolverProperty.getRefValue()) != null) {
                ViewResolver viewResolver = ThymeleafViewResolverFactory.createURLBasedViewResolver(module, templateResolver2);
                resolvers.add(viewResolver);
            }
            if ((templateResolversProperty = ((SpringBean)templateEngine).getProperty("templateResolvers")) instanceof SpringProperty) {
                Set<SpringBeanPointer> pointers = ThymeleafViewResolverFactory.getCollectionPointers((SpringProperty)templateResolversProperty);
                resolvers.addAll(pointers.stream().map(templateResolver -> ThymeleafViewResolverFactory.createURLBasedViewResolver(module, templateResolver)).collect(Collectors.toList()));
            }
        }
        HashSet<ViewResolver> hashSet = resolvers;
        if (hashSet == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    public static ViewResolver createURLBasedViewResolver(@NotNull Module module, SpringBeanPointer templateResolver) {
        if (module == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(10);
        }
        CommonSpringBean bean = templateResolver.getSpringBean();
        String prefix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"prefix");
        String suffix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"suffix");
        return new UrlBasedViewResolver(module, VIEW_RESOLVER_ID, "", prefix, suffix);
    }

    public static ViewResolver createURLBasedViewResolver(@NotNull Module module, String suffix, String prefix) {
        if (module == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(11);
        }
        return new UrlBasedViewResolver(module, VIEW_RESOLVER_ID, "", prefix, suffix);
    }

    @NotNull
    private static Set<SpringBeanPointer> getCollectionPointers(@NotNull SpringProperty springProperty) {
        if (springProperty == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(12);
        }
        LinkedHashMap beans = new LinkedHashMap();
        List listOrSets = DomUtil.getChildrenOfType((DomElement)springProperty, ListOrSet.class);
        for (ListOrSet listOrSet : listOrSets) {
            SpringPropertyUtils.addCollectionReferences((CollectionElements)listOrSet, beans);
        }
        Set<SpringBeanPointer> set = beans.keySet();
        if (set == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(13);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/thymeleaf/ThymeleafViewResolverFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverClass";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/thymeleaf/ThymeleafViewResolverFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredViewResolvers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateResolvers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredViewResolvers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateResolvers";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createURLBasedViewResolver";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionPointers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

