/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.providers;

import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.ValueKey;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.mapping.UrlMappingElement;
import com.intellij.spring.web.mvc.model.SpringMvcUrlTargetInfo;
import com.intellij.spring.web.mvc.model.SpringMvcUrlUtils;
import com.intellij.spring.web.mvc.model.mappings.UrlMappingPsiBasedElement;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringMvcServerProvider
implements EndpointsProvider<SpringBeanPointer<?>, UrlMappingElement> {
    private final FrameworkPresentation myPresentation;

    public SpringMvcServerProvider(String queryTag, String title) {
        this.myPresentation = new FrameworkPresentation(queryTag, title, SpringApiIcons.SpringWeb);
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        FrameworkPresentation frameworkPresentation = this.myPresentation;
        if (frameworkPresentation == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(0);
        }
        return frameworkPresentation;
    }

    public boolean isValidEndpoint(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        PsiElement element;
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(1);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(2);
        }
        return (element = endpoint.getNavigationTarget()) != null && element.isValid();
    }

    @Nullable
    protected String getLocationString(@NotNull SpringBeanPointer<?> beanPointer, @NotNull UrlMappingElement endpoint) {
        PsiClass beanClass;
        if (beanPointer == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(3);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(4);
        }
        if ((beanClass = beanPointer.getBeanClass()) != null) {
            return beanClass.getName();
        }
        return beanPointer.getContainingFile().getName();
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(5);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(6);
        }
        String pathPresentation = UrlMappingElement.getPathPresentation((UrlMappingElement)endpoint);
        return new HttpMethodPresentation(pathPresentation, ContainerUtil.map((Object[])endpoint.getMethod(), m -> m.name()), this.getLocationString(group, endpoint), SpringApiIcons.RequestMapping);
    }

    @Nullable
    public Object getEndpointData(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint, @NotNull String dataId) {
        Object data;
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(7);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(8);
        }
        if (dataId == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(9);
        }
        if ((data = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.URL_TARGET_INFO).thenGet(() -> {
            UrlTargetInfo urlTargetInfo = this.getUrlTargetInfo(group, endpoint);
            if (urlTargetInfo == null) {
                return null;
            }
            return Collections.singletonList(urlTargetInfo);
        }).ifEq((ValueKey)EndpointsProvider.DOCUMENTATION_ELEMENT).thenGet(() -> endpoint.getDocumentationPsiElement()).orNull()) != null) {
            return data;
        }
        return EndpointsViewUtils.getCommonEndpointValue((PsiElement)endpoint.getNavigationTarget(), (String)dataId);
    }

    @Nullable
    protected UrlTargetInfo getUrlTargetInfo(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(10);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(11);
        }
        String path = UrlMappingElement.getPathPresentation((UrlMappingElement)endpoint);
        PsiElement endpointPsiElement = endpoint.getNavigationTarget();
        PomTarget pomTarget = null;
        if (endpointPsiElement instanceof PomTargetPsiElement) {
            pomTarget = ((PomTargetPsiElement)endpointPsiElement).getTarget();
            endpointPsiElement = endpointPsiElement.getNavigationElement();
        }
        if (endpointPsiElement == null) {
            return null;
        }
        UrlMappingPsiBasedElement mapping = new UrlMappingPsiBasedElement(path, endpointPsiElement, pomTarget, endpoint.getPresentation(), endpoint.getMethod());
        Module module = (Module)ObjectUtils.doIfNotNull((Object)group.getPsiElement(), ModuleUtilCore::findModuleForPsiElement);
        return new SpringMvcUrlTargetInfo(UrlConstants.HTTP_SCHEMES, mapping, SpringMvcUrlUtils.getAuthoritiesByModule(module));
    }

    @NotNull
    public Iterable<UrlMappingElement> getEndpoints(SpringBeanPointer<?> group) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)group.getContainingFile());
        if (module == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringMvcServerProvider.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<UrlMappingElement> items = new ArrayList<UrlMappingElement>();
        SpringMvcViewUtils.processUrls(module, group, EnumSet.allOf(RequestMethod.class), (Processor<? super UrlMappingElement>)new CommonProcessors.CollectProcessor(items));
        ArrayList<UrlMappingElement> arrayList = items;
        if (arrayList == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/providers/SpringMvcServerProvider";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/providers/SpringMvcServerProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocationString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUrlTargetInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

