/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.jam.JamService;
import com.intellij.microservices.url.parameters.PathVariableDeclaringReference;
import com.intellij.microservices.utils.pathVariables.usageReference.searchers.AnnotationParamSearcherUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMember;
import com.intellij.semantic.SemKey;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.util.Plow;
import com.intellij.util.Processor;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;

public final class SpringMvcPathVariableDeclarationSearcher {
    private SpringMvcPathVariableDeclarationSearcher() {
    }

    @Nullable
    public static PathVariableDeclaringReference findPathVariableDeclaration(String pathVariableName, PsiElement context) {
        return (PathVariableDeclaringReference)SpringMvcPathVariableDeclarationSearcher.collectDeclarations(context).find(reference -> reference.getValue().equals(pathVariableName));
    }

    public static Plow<PathVariableDeclaringReference> collectDeclarations(@Nullable PsiElement context) {
        return SpringMvcPathVariableDeclarationSearcher.collectDeclarations((UMethod)UastUtils.findContaining((PsiElement)context, UMethod.class));
    }

    public static Plow<PathVariableDeclaringReference> collectDeclarations(@Nullable UMethod method) {
        return Plow.of(processor -> {
            if (!SpringMvcPathVariableDeclarationSearcher.processModifierListOwner((Processor<PathVariableDeclaringReference>)processor, (UDeclaration)method, RequestMapping.METHOD_JAM_KEY)) {
                return false;
            }
            UClass clazz = UastUtils.getContainingUClass((UElement)method);
            return SpringMvcPathVariableDeclarationSearcher.processModifierListOwner((Processor<PathVariableDeclaringReference>)processor, (UDeclaration)clazz, RequestMapping.CLASS_JAM_KEY);
        });
    }

    private static <T extends PsiMember> boolean processModifierListOwner(Processor<PathVariableDeclaringReference> processor, @Nullable UDeclaration modifierListOwner, SemKey<? extends RequestMapping<T>> jamKey) {
        if (modifierListOwner == null) {
            return false;
        }
        PsiElement jvmDeclaration = modifierListOwner.getJavaPsi();
        if (jvmDeclaration == null) {
            return false;
        }
        RequestMapping requestMapping = (RequestMapping)JamService.getJamService((Project)jvmDeclaration.getProject()).getJamElement(jamKey, jvmDeclaration);
        if (requestMapping == null) {
            return true;
        }
        return StreamEx.of(requestMapping.getMappingUrls()).map(urlAttribute -> (UExpression)UastContextKt.toUElement((PsiElement)urlAttribute.getPsiElement(), UExpression.class)).nonNull().flatMap(SpringMvcPathVariableDeclarationSearcher::getReferencesForUrlPsiElement).allMatch(arg_0 -> processor.process(arg_0));
    }

    @NotNull
    private static StreamEx<PathVariableDeclaringReference> getReferencesForUrlPsiElement(UExpression expression) {
        if (expression == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(0);
            }
            return streamEx;
        }
        PsiLanguageInjectionHost injectionHost = UastLiteralUtils.getSourceInjectionHost((UExpression)expression);
        if (injectionHost != null) {
            StreamEx streamEx = StreamEx.of((Object[])injectionHost.getReferences()).select(PathVariableDeclaringReference.class);
            if (streamEx == null) {
                SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(1);
            }
            return streamEx;
        }
        if (expression instanceof UReferenceExpression) {
            StreamEx streamEx = StreamEx.of((Object)AnnotationParamSearcherUtils.deepReferencesSearch((UExpression)expression)).select(PathVariableDeclaringReference.class);
            if (streamEx == null) {
                SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(2);
            }
            return streamEx;
        }
        if (expression instanceof UPolyadicExpression) {
            StreamEx streamEx = StreamEx.of((Collection)((UPolyadicExpression)expression).getOperands()).flatMap(operand -> SpringMvcPathVariableDeclarationSearcher.getReferencesForUrlPsiElement(operand));
            if (streamEx == null) {
                SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(3);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.empty();
        if (streamEx == null) {
            SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(4);
        }
        return streamEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/SpringMvcPathVariableDeclarationSearcher", "getReferencesForUrlPsiElement"));
    }
}

