/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.SpringControllerUtils;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.services.SpringMvcService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

public class SpringMvcRequestMappingRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public String getId() {
        return "SpringMvcRequestMappingRelatedItemLineMarkerProvider";
    }

    public String getName() {
        return SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.related.views", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.RequestMapping;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        if (!SpringMvcLibraryUtil.isSpringMVCEnabled((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(final @NotNull PsiElement context, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        NavigatablePsiElement navigatablePsiElement;
        UElement parent;
        if (context == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (!((parent = UastUtils.getUParentForIdentifier((PsiElement)context)) instanceof UMethod)) {
            return;
        }
        final PsiMethod method = ((UMethod)parent).getJavaPsi();
        if (!SpringControllerUtils.isRequestHandlerCandidate(method)) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        if (!SpringControllerUtils.isRequestHandler(method)) {
            return;
        }
        final Set views = SpringControllerClassInfo.getViews((UMethod)parent).keySet();
        if (views.isEmpty()) {
            return;
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
        SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, views, (Processor<PsiElement>)findFirstProcessor);
        if (!findFirstProcessor.isFound()) {
            return;
        }
        PsiElement firstResult = (PsiElement)findFirstProcessor.getFoundValue();
        Object object = firstResult instanceof NavigatablePsiElement ? (NavigatablePsiElement)firstResult : (navigatablePsiElement = firstResult != null ? firstResult.getContainingFile() : null);
        if (navigatablePsiElement == null) {
            return;
        }
        GutterIconNavigationHandler<PsiElement> handler = new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                String methodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)2, (int)0);
                final String title = SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.request.mapping.title", methodName);
                BackgroundUpdaterTask updaterTask = new BackgroundUpdaterTask(context.getProject(), SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.request.mapping.task.title", methodName), null){

                    public String getCaption(int size) {
                        if (this.isFinished()) {
                            return SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.request.mapping.task.finished.caption", title, size);
                        }
                        return SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.request.mapping.task.caption", title, size);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.run(indicator);
                        SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, views, (Processor<PsiElement>)((Processor)file -> {
                            ProgressManager.checkCanceled();
                            if (((Boolean)ReadAction.compute(() -> !this.updateComponent((PsiElement)file))).booleanValue()) {
                                indicator.cancel();
                            }
                            return true;
                        }));
                    }

                    public void onSuccess() {
                        super.onSuccess();
                        PsiElement oneElement = this.getTheOnlyOneElement();
                        if (oneElement instanceof NavigatablePsiElement) {
                            ((NavigatablePsiElement)oneElement).navigate(true);
                            this.myPopup.cancel();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/spring/web/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider$1$1", "run"));
                    }
                };
                PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])new NavigatablePsiElement[]{navigatablePsiElement}, (String)updaterTask.getCaption(1), (String)title, (ListCellRenderer)new DefaultPsiElementCellRenderer(), (BackgroundUpdaterTask)updaterTask);
            }
        };
        SpringGutterIconBuilder.CustomNavigationHandlerBuilder builder2 = SpringGutterIconBuilder.CustomNavigationHandlerBuilder.createBuilder((Icon)SpringApiIcons.Gutter.RequestMapping, (String)SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.related.views", new Object[0]), (GutterIconNavigationHandler)handler, dom -> GotoRelatedItem.createItems(Collections.singleton(dom), (String)SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.spring.view", new Object[0])));
        builder2.setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<? extends PsiElement> compute() {
                CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
                SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, views, (Processor<PsiElement>)processor);
                Collection collection = processor.getResults();
                if (collection == null) {
                    2.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider$2", "compute"));
            }
        });
        result.add(builder2.withElementPresentation(SpringMvcBundle.message("request.mapping.gutter.views.name", new Object[0])).createSpringRelatedMergeableLineMarkerInfo(context));
    }

    private static boolean processViews(PsiElement context, Set<String> views, Processor<PsiElement> processor) {
        return (Boolean)ReadAction.compute(() -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            if (module == null) {
                return true;
            }
            Set resolvers = SpringMvcService.getInstance().getViewResolvers(module);
            for (String view : views) {
                for (ViewResolver resolver : resolvers) {
                    PsiElement element;
                    Set psiElements = (Set)ReadAction.compute(() -> resolver.resolveView(view));
                    Iterator iterator = psiElements.iterator();
                    if (!iterator.hasNext() || processor.process((Object)(element = (PsiElement)iterator.next()))) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/web/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

