/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model.mappings.processors;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.mapping.UrlMappingElement;
import com.intellij.spring.web.mvc.model.mappings.UrlMappingPsiBasedElement;
import com.intellij.spring.web.mvc.model.mappings.processors.XmlDefinitionMappingProcessor;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebMvcConfigurationRequestMappingProcessor {
    public static boolean processWebMvcSupport(@NotNull Processor<UrlMappingElement> requestMappings, @NotNull Module module, @NotNull Collection<SpringModel> models) {
        String[] codeConfigurers;
        if (requestMappings == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(0);
        }
        if (module == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(1);
        }
        if (models == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(2);
        }
        for (String codeConfigurer : codeConfigurers = new String[]{"org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport", "org.springframework.web.servlet.config.annotation.WebMvcConfigurer"}) {
            SpringModelSearchParameters.BeanClass mvcConfigurationSupportSearchParameters = XmlDefinitionMappingProcessor.createSearchParams(module, codeConfigurer);
            if (mvcConfigurationSupportSearchParameters == null) continue;
            for (SpringModel model : models) {
                for (SpringBeanPointer pointer : SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)mvcConfigurationSupportSearchParameters)) {
                    if (WebMvcConfigurationRequestMappingProcessor.processConfigurationClass(pointer.getBeanClass(), requestMappings)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean processConfigurationClass(@Nullable PsiClass configClass, final @NotNull Processor<UrlMappingElement> processor) {
        if (processor == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(3);
        }
        if (configClass == null) {
            return true;
        }
        LightMethodBuilder addViewControllersMethod = new LightMethodBuilder(configClass.getManager(), "addViewControllers").setModifiers(new String[]{"protected"}).setMethodReturnType((PsiType)PsiType.VOID).addParameter("registry", "org.springframework.web.servlet.config.annotation.ViewControllerRegistry");
        PsiMethod configureViewResolvers = configClass.findMethodBySignature((PsiMethod)addViewControllersMethod, false);
        if (configureViewResolvers == null) {
            return true;
        }
        configureViewResolvers.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (qualifierExpression == null) {
                    return;
                }
                PsiType qualifierType = qualifierExpression.getType();
                PsiClass qualifierClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
                if (qualifierClass == null || !"org.springframework.web.servlet.config.annotation.ViewControllerRegistry".equals(qualifierClass.getQualifiedName())) {
                    return;
                }
                this.processControllers(expression, methodExpression.getReferenceName());
            }

            private boolean processControllers(PsiMethodCallExpression expression, String methodName) {
                return !("addViewController".equals(methodName) ? !WebMvcConfigurationRequestMappingProcessor.processAddViewController(expression, (Processor<UrlMappingElement>)processor) : ("addRedirectViewController".equals(methodName) ? !WebMvcConfigurationRequestMappingProcessor.processRedirectViewController(expression, (Processor<UrlMappingElement>)processor) : "addStatusController".equals(methodName) && !WebMvcConfigurationRequestMappingProcessor.processStatusController(expression, (Processor<UrlMappingElement>)processor)));
            }
        });
        return true;
    }

    private static boolean processAddViewController(@NotNull PsiMethodCallExpression expression, @NotNull Processor<UrlMappingElement> processor) {
        PsiExpression[] arguments;
        if (expression == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(5);
        }
        return (arguments = expression.getArgumentList().getExpressions()).length != 1 || WebMvcConfigurationRequestMappingProcessor.processUrlFromFirstArgument(arguments[0], processor);
    }

    private static boolean processRedirectViewController(@NotNull PsiMethodCallExpression expression, @NotNull Processor<UrlMappingElement> processor) {
        PsiExpression[] arguments;
        if (expression == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(7);
        }
        return (arguments = expression.getArgumentList().getExpressions()).length != 2 || WebMvcConfigurationRequestMappingProcessor.processUrlFromFirstArgument(arguments[0], processor);
    }

    private static boolean processStatusController(@NotNull PsiMethodCallExpression expression, @NotNull Processor<UrlMappingElement> processor) {
        PsiExpression[] arguments;
        if (expression == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(9);
        }
        return (arguments = expression.getArgumentList().getExpressions()).length != 2 || WebMvcConfigurationRequestMappingProcessor.processUrlFromFirstArgument(arguments[0], processor);
    }

    private static boolean processUrlFromFirstArgument(@NotNull PsiExpression argument, @NotNull Processor<UrlMappingElement> processor) {
        Pair urlPathExpr;
        if (argument == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(11);
        }
        return (urlPathExpr = StringExpressionHelper.evaluateExpression((PsiElement)argument)) == null || processor.process((Object)WebMvcConfigurationRequestMappingProcessor.createUrlMapping((String)urlPathExpr.getSecond(), (PsiElement)urlPathExpr.getFirst(), new RequestMethod[0]));
    }

    private static UrlMappingElement createUrlMapping(@NotNull String path, PsiElement definition, RequestMethod ... requestMethods) {
        if (path == null) {
            WebMvcConfigurationRequestMappingProcessor.$$$reportNull$$$0(12);
        }
        return new UrlMappingPsiBasedElement(path, definition, null, path, requestMethods);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/web/mvc/model/mappings/processors/WebMvcConfigurationRequestMappingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processWebMvcSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processConfigurationClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processAddViewController";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processRedirectViewController";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processStatusController";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processUrlFromFirstArgument";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createUrlMapping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

