/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model.mappings;

import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.utils.PomTargetUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.jam.SpringMvcUrlPathSpecification;
import com.intellij.spring.web.mvc.mapping.UrlMappingElement;
import icons.SpringApiIcons;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class UrlMappingPsiBasedElement
implements UrlMappingElement {
    @Nullable
    private final PomTarget predefinedPomTarget;
    private final SmartPsiElementPointer<PsiElement> myDefinition;
    private final UrlPath myUrlPath;
    private final String presentation;
    private final RequestMethod[] method;

    public UrlMappingPsiBasedElement(@NotNull String url, @NotNull PsiElement navigationElement, @Nullable PomTarget predefinedPomTarget, @Nullable String presentation, RequestMethod[] method) {
        if (url == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(0);
        }
        if (navigationElement == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(1);
        }
        this.predefinedPomTarget = predefinedPomTarget;
        Logger.getInstance(UrlMappingPsiBasedElement.class).assertTrue(navigationElement.isPhysical() || navigationElement instanceof PsiModifierListOwner, (Object)navigationElement);
        this.myDefinition = SmartPointerManager.createPointer((PsiElement)navigationElement);
        this.myUrlPath = SpringMvcUrlPathSpecification.INSTANCE.parsePath(url);
        this.presentation = presentation == url || presentation == null ? this.myUrlPath.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION) : presentation;
        this.method = method;
    }

    public String toString() {
        return this.myUrlPath + " (" + this.presentation + ")";
    }

    public PsiElement getNavigationTarget() {
        return this.myDefinition.getElement();
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        UElement uElement = UastContextKt.toUElement((PsiElement)this.myDefinition.getElement());
        if (uElement == null) {
            return super.getDocumentationPsiElement();
        }
        UDeclaration uDeclaration = (UDeclaration)UastUtils.getParentOfType((UElement)uElement, UDeclaration.class, (boolean)false);
        if (uDeclaration == null) {
            return super.getDocumentationPsiElement();
        }
        return uDeclaration.getSourcePsi();
    }

    @Deprecated
    public String getURL() {
        return this.myUrlPath.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION);
    }

    @NotNull
    public UrlPath getUrlPath() {
        UrlPath urlPath = this.myUrlPath;
        if (urlPath == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(2);
        }
        return urlPath;
    }

    public String getPresentation() {
        return this.presentation;
    }

    public RequestMethod[] getMethod() {
        return this.method;
    }

    @Nullable
    public PomNamedTarget getPomTarget() {
        if (this.predefinedPomTarget != null) {
            return PomTargetUtils.toPomRenameableTarget((PomTarget)this.predefinedPomTarget, (String)this.getPresentation(), (Icon)SpringApiIcons.RequestMapping, (String)this.getTypeName());
        }
        PsiElement navigationTarget = this.getNavigationTarget();
        if (navigationTarget == null) {
            return null;
        }
        return this.toPomTarget(navigationTarget);
    }

    @NotNull
    protected PomRenameableTarget<?> toPomTarget(PsiElement psiElement) {
        PomRenameableTarget pomRenameableTarget = PomTargetUtils.toPomRenameableTarget((PsiElement)psiElement, (String)this.getPresentation(), (Icon)SpringApiIcons.RequestMapping, (String)this.getTypeName());
        if (pomRenameableTarget == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(3);
        }
        return pomRenameableTarget;
    }

    @Nls
    protected String getTypeName() {
        return MicroservicesBundle.message((String)"microservices.url.path.segment", (Object[])new Object[0]);
    }

    public boolean canResolve(@NotNull String url) {
        if (url == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(4);
        }
        return this.myUrlPath.isCompatibleWith(SpringMvcUrlPathSpecification.INSTANCE.parsePath(url));
    }

    public boolean isDefinedInBean(SpringBeanPointer<? extends CommonSpringBean> controllerSpringBeanPointer) {
        PsiElement psiElement = this.myDefinition.getElement();
        if (psiElement == null) {
            return false;
        }
        PsiClass variantPsiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        if (variantPsiClass != null && controllerSpringBeanPointer instanceof JamSpringBeanPointer) {
            PsiManager psiManager = variantPsiClass.getManager();
            if (psiManager.areElementsEquivalent((PsiElement)variantPsiClass, (PsiElement)controllerSpringBeanPointer.getBeanClass())) {
                return true;
            }
            PsiClass controllerClass = controllerSpringBeanPointer.getBeanClass();
            if (controllerClass != null && controllerClass.isValid()) {
                for (PsiClass controllerSuperClass : controllerClass.getSupers()) {
                    if (!psiManager.areElementsEquivalent((PsiElement)variantPsiClass, (PsiElement)controllerSuperClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlMappingPsiBasedElement element = (UrlMappingPsiBasedElement)o;
        return Objects.equals(this.predefinedPomTarget, element.predefinedPomTarget) && Objects.equals(this.myDefinition.getElement(), element.myDefinition.getElement()) && this.myUrlPath.equals((Object)element.myUrlPath);
    }

    public int hashCode() {
        return Objects.hash(this.predefinedPomTarget, this.myDefinition.getElement(), this.myUrlPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/model/mappings/UrlMappingPsiBasedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/model/mappings/UrlMappingPsiBasedElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toPomTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canResolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

