/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.spring.web.mvc.services.SpringMvcServiceImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DumpSpringMVCModelAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DumpSpringMVCModelAction.$$$reportNull$$$0(0);
        }
        boolean hasSpring = (project = (Project)e.getData(CommonDataKeys.PROJECT)) != null && SpringCommonUtils.hasSpringFacets((Project)project);
        e.getPresentation().setEnabled(hasSpring);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DumpSpringMVCModelAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ThrowableComputable computable = () -> (String)ReadAction.compute(() -> DumpSpringMVCModelAction.getMvcModelDump(project));
        String dump = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, SpringMvcBundle.message("DumpSpringMVCModelAction.gathering.spring.mvc.models", new Object[0]), true, project);
        String fileName = String.format("SpringMVCModel-%s.txt", DateFormatUtil.formatDateTime((long)System.currentTimeMillis()));
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)dump);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static String getMvcModelDump(Project project) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        pi.setIndeterminate(false);
        pi.setText(SpringMvcBundle.message("DumpSpringMVCModelAction.scanning.spring.mvc.models", new Object[0]));
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        StringBuilder dump = new StringBuilder();
        int processedModules = 0;
        for (Module module : modules) {
            pi.checkCanceled();
            String name = module.getName();
            dump.append(name).append(" ").append(StringUtil.repeatSymbol((char)'=', (int)Math.max(1, 119 - name.length()))).append("\n");
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null) {
                dump.append("no Spring facet");
            } else {
                Collection webFacets = WebFacet.getInstances((Module)module);
                if (webFacets.isEmpty()) {
                    dump.append("no Web facets");
                } else {
                    DumpSpringMVCModelAction.dumpModule(dump, springFacet, webFacets);
                }
            }
            dump.append("\n\n");
            pi.setFraction((double)(++processedModules) / (double)modules.length);
        }
        return dump.toString();
    }

    private static void dumpModule(StringBuilder dump, SpringFacet springFacet, Collection<WebFacet> webFacets) {
        dump.append("Servlet models:\n");
        Set servletModels = SpringMvcServiceImpl.getServletModels((Module)springFacet.getModule());
        for (SpringModel servletModel : servletModels) {
            SpringFileSet fileSet = servletModel.getFileSet();
            assert (fileSet != null) : servletModel;
            dump.append(" ").append(fileSet.getId());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/spring/web/mvc/model/DumpSpringMVCModelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

