/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.web.mvc.model.CodeConfigurationParserBase;
import com.intellij.spring.web.mvc.views.BeanNameViewResolverFactory;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeConfigurationViewResolverParser
extends CodeConfigurationParserBase {
    private final List<? super ViewResolver> myViewResolvers;

    public CodeConfigurationViewResolverParser(CommonSpringModel servletModel, SpringBeanPointer configBeanPointer, List<? super ViewResolver> resolvers) {
        super(servletModel, configBeanPointer);
        this.myViewResolvers = resolvers;
    }

    @Override
    protected boolean parseConfigurationClass(@NotNull PsiClass configClass) {
        LightMethodBuilder configureViewResolversMethodTemplate;
        PsiMethod configureViewResolvers;
        if (configClass == null) {
            CodeConfigurationViewResolverParser.$$$reportNull$$$0(0);
        }
        if ((configureViewResolvers = configClass.findMethodBySignature((PsiMethod)(configureViewResolversMethodTemplate = new LightMethodBuilder(configClass.getManager(), "configureViewResolvers").setModifiers(new String[]{"protected"}).setMethodReturnType((PsiType)PsiType.VOID).addParameter("registry", "org.springframework.web.servlet.config.annotation.ViewResolverRegistry")), false)) == null) {
            return false;
        }
        final List viewResolverFactoryEPs = ViewResolverFactory.EP_NAME.getExtensionList();
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)configClass);
        configureViewResolvers.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (qualifierExpression == null) {
                    return;
                }
                PsiType qualifierType = qualifierExpression.getType();
                PsiClass qualifierClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
                if (qualifierClass == null || !"org.springframework.web.servlet.config.annotation.ViewResolverRegistry".equals(qualifierClass.getQualifiedName())) {
                    return;
                }
                String methodName = methodExpression.getReferenceName();
                if ("jsp".equals(methodName)) {
                    CodeConfigurationViewResolverParser.this.handleJsp(module, expression);
                } else if ("beanName".equals(methodName)) {
                    CodeConfigurationViewResolverParser.this.handleBeanName(module);
                } else {
                    for (ViewResolverFactory viewResolver : viewResolverFactoryEPs) {
                        Set viewResolvers = viewResolver.handleResolversRegistry(methodName, expression, CodeConfigurationViewResolverParser.this.myServletModel);
                        if (viewResolvers.isEmpty()) continue;
                        CodeConfigurationViewResolverParser.this.myViewResolvers.addAll(viewResolvers);
                        break;
                    }
                }
            }
        });
        return true;
    }

    private void handleJsp(@Nullable Module module, PsiMethodCallExpression expression) {
        if (module == null) {
            return;
        }
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        if (arguments.length == 0) {
            this.myViewResolvers.add((ViewResolver)new UrlBasedViewResolver(module, "CodeConfigurationViewResolverParser.jsp()", "/WEB-INF/", "", ".jsp"));
            return;
        }
        if (arguments.length == 2) {
            Pair prefixExpr = StringExpressionHelper.evaluateExpression((PsiElement)arguments[0]);
            Pair suffixExpr = StringExpressionHelper.evaluateExpression((PsiElement)arguments[1]);
            if (prefixExpr != null && suffixExpr != null) {
                this.myViewResolvers.add((ViewResolver)new UrlBasedViewResolver(module, "CodeConfigurationViewResolverParser.jsp()", "", (String)prefixExpr.getSecond(), (String)suffixExpr.getSecond()));
            }
        }
    }

    private void handleBeanName(@Nullable Module module) {
        if (module == null) {
            return;
        }
        this.myViewResolvers.add(new BeanNameViewResolverFactory.BeanNameViewResolver(module, "CodeConfigurationViewResolverParser.beanName()"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configClass", "com/intellij/spring/web/mvc/model/CodeConfigurationViewResolverParser", "parseConfigurationClass"));
    }
}

