/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class CodeConfigurationParserBase {
    protected final CommonSpringModel myServletModel;
    protected final Module myModule;
    private final SpringBeanPointer myConfigBeanPointer;

    protected CodeConfigurationParserBase(CommonSpringModel model, SpringBeanPointer pointer) {
        this.myServletModel = model;
        this.myModule = model.getModule();
        this.myConfigBeanPointer = pointer;
    }

    public final boolean collect() {
        PsiClass configClass = this.myConfigBeanPointer.getBeanClass();
        if (!CodeConfigurationParserBase.isRelevantConfigClass(configClass)) {
            return false;
        }
        if ("org.springframework.web.servlet.config.annotation.DelegatingWebMvcConfiguration".equals(configClass.getQualifiedName())) {
            return this.parseDelegatingWebMvcConfiguration();
        }
        return this.parseConfigurationClass(configClass);
    }

    protected abstract boolean parseConfigurationClass(PsiClass var1);

    private boolean parseDelegatingWebMvcConfiguration() {
        PsiClass webMvcConfigurerClass = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)"org.springframework.web.servlet.config.annotation.WebMvcConfigurer");
        if (webMvcConfigurerClass == null) {
            return false;
        }
        SpringModelSearchParameters.BeanClass webMvcConfigurersSearchParams = SpringModelSearchParameters.byClass((PsiClass)webMvcConfigurerClass).withInheritors();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)this.myServletModel, (SpringModelSearchParameters.BeanClass)webMvcConfigurersSearchParams);
        for (SpringBeanPointer configurer : configurers) {
            PsiClass configurerBeanClass = configurer.getBeanClass();
            if (!CodeConfigurationParserBase.isRelevantConfigClass(configurerBeanClass)) continue;
            this.parseConfigurationClass(configurerBeanClass);
        }
        return true;
    }

    private static boolean isRelevantConfigClass(@Nullable PsiClass configClass) {
        return configClass != null && !configClass.hasModifierProperty("abstract");
    }
}

