/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.groovy;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.mvc.GroovyConfigurer;
import com.intellij.spring.web.mvc.views.TemplateViewResolverFactory;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.WithPrefixSuffix;
import org.jetbrains.annotations.NotNull;

public class GroovyTemplateViewResolverFactory
extends TemplateViewResolverFactory {
    public GroovyTemplateViewResolverFactory() {
        super("org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver", "org.springframework.web.servlet.view.groovy.GroovyMarkupConfigurer", "resourceLoaderPath", ".tpl");
    }

    @Override
    protected String getViewResolverRegistryMethodName() {
        return "groovy";
    }

    @Override
    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, WithPrefixSuffix resolver) {
        Module configurerModule = configurer.getModule();
        if (configurer instanceof GroovyConfigurer && configurerModule != null) {
            GroovyConfigurer groovyConfigurer = (GroovyConfigurer)configurer;
            String resourceLoaderPath = groovyConfigurer.getResourceLoaderPath().getStringValue();
            return new UrlBasedViewResolver(configurerModule, "GroovyTemplateViewResolverFactory", "", StringUtil.defaultIfEmpty((String)resourceLoaderPath, (String)"classpath:"), "");
        }
        ViewResolver viewResolver = super.handleCustomConfigurer(configurer, resolver);
        if (viewResolver == null) {
            GroovyTemplateViewResolverFactory.$$$reportNull$$$0(0);
        }
        return viewResolver;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/groovy/GroovyTemplateViewResolverFactory", "handleCustomConfigurer"));
    }
}

