/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.freemarker;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.mvc.FreeMarkerConfigurer;
import com.intellij.spring.model.xml.mvc.FreeMarkerTemplateLoaderPath;
import com.intellij.spring.web.mvc.views.TemplateViewResolverFactory;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.WithPrefixSuffix;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FreemarkerViewResolverFactory
extends TemplateViewResolverFactory {
    public FreemarkerViewResolverFactory() {
        super("org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver", "org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer", "templateLoaderPath", ".ftl");
    }

    @Override
    protected String getViewResolverRegistryMethodName() {
        return "freeMarker";
    }

    @Override
    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, WithPrefixSuffix resolver) {
        FreeMarkerConfigurer freeMarkerConfigurer;
        List<FreeMarkerTemplateLoaderPath> paths;
        Module configurerModule = configurer.getModule();
        if (configurer instanceof FreeMarkerConfigurer && configurerModule != null && (paths = (freeMarkerConfigurer = (FreeMarkerConfigurer)configurer).getTemplateLoaderPaths()).size() == 1) {
            FreeMarkerTemplateLoaderPath templateLoaderPath = paths.get(0);
            String location = templateLoaderPath.getLocation().getStringValue();
            return new UrlBasedViewResolver(configurerModule, "FreemarkerViewResolverFactory", "", StringUtil.defaultIfEmpty((String)location, (String)"/WEB-INF/"), "");
        }
        ViewResolver viewResolver = super.handleCustomConfigurer(configurer, resolver);
        if (viewResolver == null) {
            FreemarkerViewResolverFactory.$$$reportNull$$$0(0);
        }
        return viewResolver;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/freemarker/FreemarkerViewResolverFactory", "handleCustomConfigurer"));
    }
}

