/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.microservices.url.parameters.PathVariablePsiElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.web.mvc.CommonFakePsiVariablePomTarget;
import com.intellij.spring.web.mvc.SpringControllerUtils;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.spring.web.mvc.jsp.SpringModelELVariable;
import com.intellij.spring.web.mvc.pathVariables.SpringMvcPathVariableDeclarationSearcher;
import com.intellij.spring.web.mvc.views.SpringMVCViewUastReferenceProvider;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

class SpringControllerModelVariablesCollector {
    @NonNls
    private static final String MODEL = "org.springframework.ui.Model";
    @NonNls
    private static final String MODEL_MAP = "org.springframework.ui.ModelMap";
    private static final UExpressionPattern<UExpression, ?> IMPLICIT_ATTRIBUTE_PATTERN = (UExpressionPattern)UastPatterns.uExpression().andOr(new ElementPattern[]{UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addObject")).withParameterCount(1).inClass("org.springframework.web.servlet.ModelAndView"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addAttribute")).withParameterCount(1).inClass("org.springframework.ui.Model"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"addAttribute", "addObject"})).withParameterCount(1).inClass("org.springframework.ui.ModelMap"), false)});
    @NonNls
    private static final String REDIRECT_ATTRIBUTES = "org.springframework.web.servlet.mvc.support.RedirectAttributes";
    private static final UExpressionPattern<UExpression, ?> ATTRIBUTE_PATTERN = (UExpressionPattern)((UExpressionPattern.Capture)UastPatterns.injectionHostOrReferenceExpression().withSourcePsiCondition(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).andOr(new ElementPattern[]{UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addObject")).inClass("org.springframework.web.servlet.ModelAndView"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addAttribute")).inClass("org.springframework.ui.Model"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"addAttribute", "addObject"})).inClass("org.springframework.ui.ModelMap"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addFlashAttribute")).inClass("org.springframework.web.servlet.mvc.support.RedirectAttributes"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("modelAttribute")).inClass("org.springframework.web.reactive.result.view.Rendering.Builder"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("put")).inClass("java.util.Map"), false), UastPatterns.uExpression().annotationParams("org.springframework.web.bind.annotation.ModelAttribute", (ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"value", "name"})), UastPatterns.uExpression().constructorParameter(1, "org.springframework.web.servlet.ModelAndView"), UastPatterns.uExpression().constructorParameter(0, "org.springframework.ui.ModelMap"), UastPatterns.uExpression().arrayAccessParameterOf((ElementPattern)PsiJavaPatterns.psiClass().inheritorOf(false, PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"org.springframework.ui.Model", "org.springframework.ui.ModelMap"}))))});
    private static final UExpressionPattern<UExpression, ?> SESSION_ATTRIBUTES_PATTERN = UastPatterns.injectionHostUExpression().annotationParams("org.springframework.web.bind.annotation.SessionAttributes", (ElementPattern)StandardPatterns.string().oneOf(new String[]{"value", "names"}));

    SpringControllerModelVariablesCollector() {
    }

    static MultiMap<String, PsiVariable> getVariables(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(0);
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.createSingleDependency(SpringControllerModelVariablesCollector.getVariableMap(psiClass), (Object)PsiModificationTracker.MODIFICATION_COUNT));
    }

    @NotNull
    private static MultiMap<String, PsiVariable> getVariableMap(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(1);
        }
        MultiMap result = new MultiMap();
        for (PsiMethod method : psiClass.getAllMethods()) {
            UMethod uMethod;
            if (!SpringControllerUtils.isRequestHandler(psiClass, method) || (uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class)) == null) continue;
            ViewsAndVariablesCollector visitor = new ViewsAndVariablesCollector(psiClass);
            uMethod.accept((UastVisitor)visitor);
            List<PsiVariable> pathVariables = SpringControllerModelVariablesCollector.collectPathVariables(psiClass, uMethod);
            for (String view : visitor.getVisitorViews()) {
                result.putValues((Object)view, visitor.getVisitorVariables());
                result.putValues((Object)view, pathVariables);
            }
        }
        if (!SpringControllerUtils.isInheritedController(psiClass)) {
            SpringControllerModelVariablesCollector.processGlobalModelAttributes(psiClass, (MultiMap<String, PsiVariable>)result);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    private static List<PsiVariable> collectPathVariables(@NotNull PsiClass psiClass, UMethod uMethod) {
        if (psiClass == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(3);
        }
        return SpringMvcPathVariableDeclarationSearcher.collectDeclarations(uMethod).map(mvcPathVariableRef -> {
            PathVariablePsiElement variablePsiElement = mvcPathVariableRef.resolve();
            return new CommonFakePsiVariablePomTarget(psiClass.getProject(), (PomRenameableTarget<? extends Object>)variablePsiElement.getVariablePomTarget(), (PsiType)PsiType.getJavaLangString((PsiManager)variablePsiElement.getManager(), (GlobalSearchScope)variablePsiElement.getResolveScope()));
        }).toList();
    }

    private static void processGlobalModelAttributes(@NotNull PsiClass psiClass, MultiMap<String, PsiVariable> result) {
        if (psiClass == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(4);
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            SpringMVCModelAttribute modelAttribute;
            if (method.isConstructor() || (modelAttribute = (SpringMVCModelAttribute)SpringMVCModelAttribute.METHOD_META.getJamElement((PsiModifierListOwner)method)) == null) continue;
            if (PsiType.VOID.equals((Object)method.getReturnType())) {
                UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class);
                if (uMethod == null) continue;
                ViewsAndVariablesCollector visitor = new ViewsAndVariablesCollector(psiClass);
                uMethod.accept((UastVisitor)visitor);
                for (Map.Entry entry : result.entrySet()) {
                    ((Collection)entry.getValue()).addAll(visitor.getVisitorVariables());
                }
                continue;
            }
            String name = modelAttribute.getName();
            if (name == null) continue;
            SpringModelELVariable var = new SpringModelELVariable((PsiElement)psiClass, name, modelAttribute.getType(), PomService.convertToPsi((PsiTarget)modelAttribute.getPsiTarget()), "NESTED");
            for (Map.Entry entry : result.entrySet()) {
                ((Collection)entry.getValue()).add(var);
            }
        }
    }

    @Nullable
    private static ELImplicitVariable createVariable(PsiElement scope, UExpression declaration) {
        List arguments;
        int i2;
        String name = UastUtils.evaluateString((UExpression)declaration);
        if (name == null) {
            return null;
        }
        PsiLanguageInjectionHost sourcePsi = UastLiteralUtils.getSourceInjectionHost((UExpression)declaration);
        if (sourcePsi == null) {
            sourcePsi = declaration.getSourcePsi();
        }
        if (sourcePsi == null) {
            return null;
        }
        PsiType type = null;
        UElement parent = declaration.getUastParent();
        if (parent instanceof UCallExpression && (i2 = (arguments = ((UCallExpression)parent).getValueArguments()).indexOf(declaration)) != -1 && arguments.size() > i2 + 1) {
            type = ((UExpression)arguments.get(i2 + 1)).getExpressionType();
        }
        if (type == null) {
            UMethod psiMethod;
            UParameter psiParameter = (UParameter)UastUtils.getParentOfType((UElement)declaration, UParameter.class);
            type = psiParameter != null ? psiParameter.getType() : ((psiMethod = (UMethod)UastUtils.getParentOfType((UElement)declaration, UMethod.class)) == null ? null : psiMethod.getReturnType());
        }
        return new SpringModelELVariable(scope, name, type, (PsiElement)sourcePsi, "NESTED");
    }

    static void registerModelVariablesReferenceProvider(PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, ATTRIBUTE_PATTERN, (UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((expression, host) -> {
            PsiReference[] psiReferenceArray;
            UClass psiClass = UastUtils.getContainingUClass((UElement)expression);
            if (psiClass == null) {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            } else {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = PsiReferenceBase.createSelfReference((PsiElement)host, (PsiElement)SpringControllerModelVariablesCollector.createVariable((PsiElement)psiClass.getJavaPsi(), expression));
            }
            return psiReferenceArray;
        }), (double)0.0);
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, SESSION_ATTRIBUTES_PATTERN, (UastReferenceProvider)UastReferenceRegistrar.uastReferenceProvider(UInjectionHost.class, (uhost, __) -> {
            final String name = uhost.evaluateToString();
            return new PsiReference[]{new PsiPolyVariantReferenceBase<PsiLanguageInjectionHost>(uhost.getPsiLanguageInjectionHost(), false){

                @NotNull
                public ResolveResult[] multiResolve(boolean incompleteCode) {
                    ResolveResult[] resolveResultArray = (ResolveResult[])this.getVariables().stream().filter(v -> Objects.equals(v.getName(), name)).map(var -> new PsiElementResolveResult((PsiElement)var)).collect(MoreCollectors.toArray(ResolveResult[]::new));
                    if (resolveResultArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return resolveResultArray;
                }

                @NotNull
                public Collection<? extends PsiVariable> getVariables() {
                    UClass uClass = (UClass)UastUtils.findContaining((PsiElement)this.getElement(), UClass.class);
                    if (uClass == null) {
                        List list = Collections.emptyList();
                        if (list == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return list;
                    }
                    Collection collection = SpringControllerModelVariablesCollector.getVariables(uClass.getJavaPsi()).values();
                    if (collection == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return collection;
                }

                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = this.getVariables().toArray();
                    if (objectArray == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return objectArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/spring/web/mvc/SpringControllerModelVariablesCollector$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "multiResolve";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getVariables";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getVariants";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }};
        }), (double)0.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/SpringControllerModelVariablesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/SpringControllerModelVariablesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariables";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVariableMap";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectPathVariables";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalModelAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ViewsAndVariablesCollector
    extends AbstractUastVisitor {
        private final Set<PsiMethod> visited;
        @NotNull
        private final PsiClass myPsiClass;
        private final Set<String> myVisitorViews;
        private final List<PsiVariable> myVisitorVariables;

        private ViewsAndVariablesCollector(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                ViewsAndVariablesCollector.$$$reportNull$$$0(0);
            }
            this.visited = new HashSet<PsiMethod>();
            this.myVisitorViews = new HashSet<String>();
            this.myVisitorVariables = new SmartList();
            this.myPsiClass = psiClass;
        }

        public boolean visitExpression(@NotNull UExpression element) {
            PsiType type;
            String variableName;
            if (element == null) {
                ViewsAndVariablesCollector.$$$reportNull$$$0(1);
            }
            if (element instanceof UReferenceExpression || UastLiteralUtils.isInjectionHost((UElement)element)) {
                if (SpringMVCViewUastReferenceProvider.VIEW_PATTERN.accepts((Object)element)) {
                    String literalName = UastUtils.evaluateString((UExpression)element);
                    ContainerUtil.addIfNotNull(this.myVisitorViews, (Object)literalName);
                } else if (ATTRIBUTE_PATTERN.accepts((Object)element)) {
                    ELImplicitVariable variable = SpringControllerModelVariablesCollector.createVariable((PsiElement)this.myPsiClass.getContainingFile(), element);
                    ContainerUtil.addIfNotNull(this.myVisitorVariables, (Object)variable);
                }
            }
            if (IMPLICIT_ATTRIBUTE_PATTERN.accepts((Object)element) && (variableName = SpringControllerUtils.getVariableName(type = element.getExpressionType())) != null) {
                SpringModelELVariable elVariable = new SpringModelELVariable((PsiElement)this.myPsiClass.getContainingFile(), variableName, type, element.getSourcePsi(), "NESTED");
                this.myVisitorVariables.add((PsiVariable)elVariable);
            }
            return false;
        }

        public boolean visitCallExpression(@NotNull UCallExpression element) {
            PsiMethod method;
            if (element == null) {
                ViewsAndVariablesCollector.$$$reportNull$$$0(2);
            }
            if ((method = element.resolve()) != null && !(method instanceof PsiCompiledElement) && this.visited.add(method) && InheritanceUtil.isInheritorOrSelf((PsiClass)this.myPsiClass, (PsiClass)method.getContainingClass(), (boolean)true)) {
                UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class);
                if (uMethod != null) {
                    uMethod.accept((UastVisitor)this);
                }
                return false;
            }
            return super.visitCallExpression(element);
        }

        private Set<String> getVisitorViews() {
            return this.myVisitorViews;
        }

        private List<PsiVariable> getVisitorVariables() {
            return this.myVisitorVariables;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/web/mvc/SpringControllerModelVariablesCollector$ViewsAndVariablesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

