/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.functional.webSockets;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.functional.SpringFunctionalRoutingUrlMapping;
import com.intellij.spring.functional.utils.SpringMvcFunctionalSearchers;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.uast.UastSmartPointer;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public final class SpringReactiveWebSocketsUtil {
    public static Set<SpringBeanPointer> getReactiveHandlerMapping(@NotNull Module module) {
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(0);
        }
        return SpringReactiveWebSocketsUtil.getReactiveHandlerMapping(module, SpringManager.getInstance((Project)module.getProject()).getAllModels(module));
    }

    private static Set<SpringBeanPointer> getReactiveHandlerMapping(@NotNull Module module, @NotNull Collection<SpringModel> models) {
        PsiClass handlerMapping;
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(1);
        }
        if (models == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(2);
        }
        if ((handlerMapping = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.HandlerMapping")) == null) {
            return Collections.emptySet();
        }
        HashSet<SpringBeanPointer> pointers = new HashSet<SpringBeanPointer>();
        for (SpringModel model : models) {
            pointers.addAll(SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)handlerMapping).withInheritors()));
        }
        return pointers;
    }

    public static boolean processReactiveHandlerMappings(@NotNull Processor<SpringFunctionalRoutingUrlMapping> processor, @NotNull Module module, @NotNull Collection<SpringModel> models) {
        if (processor == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(3);
        }
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(4);
        }
        if (models == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(5);
        }
        for (SpringBeanPointer handlerMapping : SpringReactiveWebSocketsUtil.getReactiveHandlerMapping(module, models)) {
            if (SpringReactiveWebSocketsUtil.processReactiveHandlerMappingBean(processor, module, handlerMapping)) continue;
            return false;
        }
        return true;
    }

    public static boolean processReactiveHandlerMappingBean(@NotNull Processor<SpringFunctionalRoutingUrlMapping> processor, @NotNull Module module, @NotNull SpringBeanPointer handlerMapping) {
        CommonSpringBean bean;
        PsiElement definitionScope;
        if (processor == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(6);
        }
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(7);
        }
        if (handlerMapping == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(8);
        }
        return !((definitionScope = (bean = handlerMapping.getSpringBean()).getIdentifyingPsiElement()) instanceof PsiMethod) || SpringReactiveWebSocketsUtil.processReactiveMappings(processor, module, new LocalSearchScope(definitionScope));
    }

    private static boolean processReactiveMappings(@NotNull Processor<SpringFunctionalRoutingUrlMapping> processor, @NotNull Module module, @NotNull LocalSearchScope scope) {
        if (processor == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(9);
        }
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(11);
        }
        for (UExpression expression : SpringReactiveWebSocketsUtil.getSimpleHandlerMappingInitExpressions(module, scope)) {
            PsiElement initializationScope;
            if (!SpringReactiveWebSocketsUtil.isWebsocketMapInitialization(expression, module) || (initializationScope = SpringReactiveWebSocketsUtil.getMapInitializationScope(expression)) == null) continue;
            if (!SpringReactiveWebSocketsUtil.processPutMethodInvocations(processor, module, new LocalSearchScope(initializationScope))) {
                return false;
            }
            if (!SpringReactiveWebSocketsUtil.processMapOfInvocations(processor, module, new LocalSearchScope(initializationScope))) {
                return false;
            }
            if (SpringReactiveWebSocketsUtil.processKotlinBinaryExpressions(processor, module, initializationScope)) continue;
            return false;
        }
        return true;
    }

    private static boolean processKotlinBinaryExpressions(final @NotNull Processor<SpringFunctionalRoutingUrlMapping> processor, final @NotNull Module module, @NotNull PsiElement scope) {
        UElement uElement;
        if (processor == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(12);
        }
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(14);
        }
        if ((uElement = UastContextKt.toUElement((PsiElement)scope)) == null) {
            return true;
        }
        AbstractUastVisitor nonRecursiveVisitor = new AbstractUastVisitor(){

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                UExpression leftOperand;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((leftOperand = node.getLeftOperand()) instanceof UArrayAccessExpression) {
                    List indices = ((UArrayAccessExpression)leftOperand).getIndices();
                    for (UExpression indexExpression : indices) {
                        if (SpringReactiveWebSocketsUtil.processWebSocketPathInitialization((Processor<SpringFunctionalRoutingUrlMapping>)processor, module, node.getRightOperand(), indexExpression)) continue;
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/functional/webSockets/SpringReactiveWebSocketsUtil$1", "visitBinaryExpression"));
            }
        };
        uElement.accept((UastVisitor)nonRecursiveVisitor);
        return true;
    }

    private static boolean processPutMethodInvocations(@NotNull Processor<SpringFunctionalRoutingUrlMapping> processor, @NotNull Module module, @NotNull LocalSearchScope initializationScope) {
        if (processor == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(15);
        }
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(16);
        }
        if (initializationScope == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(17);
        }
        for (UCallExpression uCallExpression : SpringReactiveWebSocketsUtil.getPutMethodInvocations(module, initializationScope)) {
            UExpression pathExpression;
            UExpression webSocket = uCallExpression.getArgumentForParameter(1);
            if (SpringReactiveWebSocketsUtil.processWebSocketPathInitialization(processor, module, webSocket, pathExpression = uCallExpression.getArgumentForParameter(0))) continue;
            return false;
        }
        return true;
    }

    private static boolean processWebSocketPathInitialization(@NotNull Processor<SpringFunctionalRoutingUrlMapping> processor, Module module, @Nullable UExpression webSocketExpression, @Nullable UExpression pathExpression) {
        String path;
        PsiElement sourcePsi;
        if (processor == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(18);
        }
        if (pathExpression == null || webSocketExpression == null) {
            return true;
        }
        return !SpringReactiveWebSocketsUtil.isWebsocketHandlerType(module, webSocketExpression.getExpressionType()) || (sourcePsi = pathExpression.getSourcePsi()) == null || (path = UastUtils.evaluateString((UExpression)pathExpression)) == null || processor.process((Object)new SpringReactiveWebSocketRoutingUrlMapping(path, sourcePsi, webSocketExpression));
    }

    private static boolean processMapOfInvocations(@NotNull Processor<SpringFunctionalRoutingUrlMapping> processor, @NotNull Module module, @NotNull LocalSearchScope initializationScope) {
        if (processor == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(19);
        }
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(20);
        }
        if (initializationScope == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(21);
        }
        for (UCallExpression uCallExpression : SpringReactiveWebSocketsUtil.getMapOfMethodInvocations(module, initializationScope)) {
            int count = uCallExpression.getValueArgumentCount();
            if (count % 2 != 0) continue;
            for (int i2 = 0; i2 < count; i2 += 2) {
                if (SpringReactiveWebSocketsUtil.processWebSocketPathInitialization(processor, module, uCallExpression.getArgumentForParameter(i2 + 1), uCallExpression.getArgumentForParameter(i2))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isWebsocketHandlerType(@NotNull Module module, @Nullable PsiType type) {
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(22);
        }
        if (type == null) {
            return false;
        }
        boolean inheritor = InheritanceUtil.isInheritor((PsiType)type, (String)"org.springframework.web.reactive.socket.WebSocketHandler");
        if (inheritor) {
            return true;
        }
        PsiClass libraryClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.socket.WebSocketHandler");
        return libraryClass != null && type.isAssignableFrom((PsiType)JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(libraryClass));
    }

    private static boolean isStringType(@Nullable PsiType type) {
        return InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.String");
    }

    private static boolean isWebsocketMapInitialization(@Nullable UExpression mapInitExpression, @NotNull Module module) {
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(23);
        }
        if (mapInitExpression == null) {
            return false;
        }
        PsiType expressionType = mapInitExpression.getExpressionType();
        if (InheritanceUtil.isInheritor((PsiType)expressionType, (String)"java.util.Map")) {
            return SpringReactiveWebSocketsUtil.isWebsocketHandlerType(module, PsiUtil.substituteTypeParameter((PsiType)expressionType, (String)"java.util.Map", (int)1, (boolean)false)) && SpringReactiveWebSocketsUtil.isStringType(PsiUtil.substituteTypeParameter((PsiType)expressionType, (String)"java.util.Map", (int)0, (boolean)false));
        }
        return false;
    }

    @Nullable
    public static PsiElement getMapInitializationScope(@Nullable UExpression expression) {
        UMethod uMethod;
        if (expression == null) {
            return null;
        }
        if (expression instanceof UCallExpression) {
            return ((UCallExpression)expression).resolve();
        }
        if (expression instanceof UReferenceExpression) {
            PsiMethodPattern of;
            PsiElement resolve2 = ((UReferenceExpression)expression).resolve();
            if (resolve2 instanceof PsiMethod && (of = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("of")).definedInClass("java.util.Map")).accepts((Object)resolve2)) {
                return expression.getSourcePsi();
            }
            if (resolve2 instanceof PsiLocalVariable) {
                UMethod uMethod2 = (UMethod)UastContextKt.getUastParentOfType((PsiElement)resolve2, UMethod.class);
                if (uMethod2 != null) {
                    return uMethod2.getSourcePsi();
                }
            } else {
                return resolve2;
            }
        }
        return (uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)expression.getSourcePsi(), UMethod.class)) == null ? null : uMethod.getPsi();
    }

    @NotNull
    public static Set<UExpression> getSimpleHandlerMappingInitExpressions(@NotNull Module module, @NotNull LocalSearchScope scope) {
        PsiMethod setUrlMapMethod;
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(25);
        }
        if ((setUrlMapMethod = SpringReactiveWebSocketsUtil.getSetUrlMapMethod(module)) == null) {
            Set<UExpression> set = Collections.emptySet();
            if (set == null) {
                SpringReactiveWebSocketsUtil.$$$reportNull$$$0(26);
            }
            return set;
        }
        Set<UExpression> set = MethodReferencesSearch.search((PsiMethod)setUrlMapMethod, (SearchScope)scope, (boolean)true).findAll().stream().map(reference -> {
            PsiElement referenceElement = reference.getElement();
            UCallExpression uCallExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)referenceElement, UCallExpression.class);
            if (uCallExpression != null) {
                return uCallExpression.getArgumentForParameter(0);
            }
            UBinaryExpression uBinaryExpression = (UBinaryExpression)UastContextKt.getUastParentOfType((PsiElement)referenceElement, UBinaryExpression.class);
            if (uBinaryExpression != null) {
                return uBinaryExpression.getRightOperand();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(27);
        }
        return set;
    }

    @Nullable
    private static PsiMethod getSetUrlMapMethod(@NotNull Module module) {
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(28);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod("setUrlMap", SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.handler.SimpleUrlHandlerMapping")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    private static PsiMethod getPutMethodOfMap(@NotNull Module module) {
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(29);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod("put", SpringCommonUtils.findLibraryClass((Module)module, (String)"java.util.Map")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @NotNull
    public static Set<UCallExpression> getPutMethodInvocations(@NotNull Module module, @NotNull LocalSearchScope scope) {
        PsiMethod putMethod;
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(31);
        }
        if ((putMethod = SpringReactiveWebSocketsUtil.getPutMethodOfMap(module)) == null) {
            Set<UCallExpression> set = Collections.emptySet();
            if (set == null) {
                SpringReactiveWebSocketsUtil.$$$reportNull$$$0(32);
            }
            return set;
        }
        Set<UCallExpression> set = MethodReferencesSearch.search((PsiMethod)putMethod, (SearchScope)scope, (boolean)true).findAll().stream().map(reference -> (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)reference.getElement(), UCallExpression.class)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(33);
        }
        return set;
    }

    @NotNull
    public static Set<UCallExpression> getMapOfMethodInvocations(@NotNull Module module, @NotNull LocalSearchScope scope) {
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(35);
        }
        for (PsiMethod ofMethod : SpringReactiveWebSocketsUtil.getMapOfMethods(module)) {
            Collection references = MethodReferencesSearch.search((PsiMethod)ofMethod, (SearchScope)scope, (boolean)true).findAll();
            if (references.size() <= 0) continue;
            Set<UCallExpression> set = references.stream().map(reference -> (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)reference.getElement(), UCallExpression.class)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (set == null) {
                SpringReactiveWebSocketsUtil.$$$reportNull$$$0(36);
            }
            return set;
        }
        Set<UCallExpression> set = Collections.emptySet();
        if (set == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(37);
        }
        return set;
    }

    @NotNull
    private static PsiMethod[] getMapOfMethods(@NotNull Module module) {
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(38);
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringReactiveWebSocketsUtil.getMapOfs(module), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
        if (psiMethodArray == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(39);
        }
        return psiMethodArray;
    }

    private static PsiMethod[] getMapOfs(@NotNull Module module) {
        PsiClass mapClass;
        if (module == null) {
            SpringReactiveWebSocketsUtil.$$$reportNull$$$0(40);
        }
        return (mapClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"java.util.Map")) != null ? mapClass.findMethodsByName("of", false) : PsiMethod.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerMapping";
                break;
            }
            case 11: 
            case 14: 
            case 25: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializationScope";
                break;
            }
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/functional/webSockets/SpringReactiveWebSocketsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/functional/webSockets/SpringReactiveWebSocketsUtil";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleHandlerMappingInitExpressions";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPutMethodInvocations";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapOfMethodInvocations";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapOfMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReactiveHandlerMapping";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReactiveHandlerMappings";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReactiveHandlerMappingBean";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processReactiveMappings";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processKotlinBinaryExpressions";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processPutMethodInvocations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processWebSocketPathInitialization";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processMapOfInvocations";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isWebsocketHandlerType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isWebsocketMapInitialization";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleHandlerMappingInitExpressions";
                break;
            }
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSetUrlMapMethod";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPutMethodOfMap";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPutMethodInvocations";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMapOfMethodInvocations";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getMapOfMethods";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getMapOfs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SpringReactiveWebSocketRoutingUrlMapping
    extends SpringFunctionalRoutingUrlMapping {
        private final UastSmartPointer<UExpression> myHandlerDefinition;

        private SpringReactiveWebSocketRoutingUrlMapping(String path, PsiElement sourcePsi, @NotNull UExpression webSocketExpression) {
            if (webSocketExpression == null) {
                SpringReactiveWebSocketRoutingUrlMapping.$$$reportNull$$$0(0);
            }
            super(path, sourcePsi, null, RequestMethod.EMPTY_ARRAY);
            this.myHandlerDefinition = new UastSmartPointer((UElement)webSocketExpression, UExpression.class);
        }

        @Override
        @Nullable
        public PsiElement getDocumentationPsiElement() {
            UExpression element = (UExpression)this.myHandlerDefinition.getElement();
            if (element == null) {
                return null;
            }
            PsiType type = element.getExpressionType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            return ((PsiClassType)type).resolve();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webSocketExpression", "com/intellij/spring/functional/webSockets/SpringReactiveWebSocketsUtil$SpringReactiveWebSocketRoutingUrlMapping", "<init>"));
        }
    }
}

