/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.functional.webClient;

import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.functional.utils.SpringFunctionalRoutingUastUtil;
import com.intellij.spring.functional.webClient.WebClientModel;
import com.intellij.spring.webClient.SpringWebClientModel;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH$J\b\u0010\f\u001a\u00020\u000bH$J\b\u0010\r\u001a\u00020\u000bH$J\b\u0010\u000e\u001a\u00020\u000bH$\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/functional/webClient/WebClientModel;", "Lcom/intellij/spring/webClient/SpringWebClientModel;", "()V", "findBaseUrl", "", "uExpression", "Lorg/jetbrains/uast/UExpression;", "findHttpMethod", "urlNode", "Lorg/jetbrains/uast/UCallExpression;", "getHttpMethodPattern", "Lcom/intellij/patterns/uast/UCallExpressionPattern;", "getHttpMethodsPattern", "getWebClientBuilderUrlPattern", "getWebClientCreatePattern", "intellij.spring.mvc.impl"})
public abstract class WebClientModel
extends SpringWebClientModel {
    @Override
    @Nullable
    public String findBaseUrl(@Nullable UExpression uExpression) {
        UElement methodScopeUElement;
        UElement resolveToUElement;
        if (uExpression == null) {
            return null;
        }
        UCallExpression firstCallExpressionsInChain = SpringFunctionalRoutingUastUtil.findFirstCallExpressionsInChain(uExpression, this.getWebClientCreatePattern());
        if (firstCallExpressionsInChain != null) {
            return this.getExpressionValue(firstCallExpressionsInChain.getArgumentForParameter(0));
        }
        firstCallExpressionsInChain = SpringFunctionalRoutingUastUtil.findFirstCallExpressionsInChain(uExpression, this.getWebClientBuilderUrlPattern());
        if (firstCallExpressionsInChain != null) {
            return this.getExpressionValue(firstCallExpressionsInChain.getArgumentForParameter(0));
        }
        UExpression firstInChain = SpringFunctionalRoutingUastUtil.getFirstInChain(uExpression);
        if (!InheritanceUtil.isInheritor((PsiType)firstInChain.getExpressionType(), (String)"org.springframework.web.reactive.function.client.WebClient")) {
            return null;
        }
        if (firstInChain instanceof USimpleNameReferenceExpression && (resolveToUElement = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)firstInChain))) instanceof UVariable) {
            return this.findBaseUrl(((UVariable)resolveToUElement).getUastInitializer());
        }
        if (firstInChain instanceof UCallExpression && (methodScopeUElement = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)firstInChain))) instanceof UMethod) {
            UExpression uBody;
            UExpression uExpression2 = ((UMethod)methodScopeUElement).getUastBody();
            if (!(uExpression2 instanceof UBlockExpression)) {
                uExpression2 = null;
            }
            UBlockExpression uBlockExpression = (UBlockExpression)uExpression2;
            if (uBlockExpression == null) {
                return null;
            }
            UExpression uExpression3 = uBody = (UExpression)uBlockExpression;
            if (uExpression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UBlockExpression");
            }
            List returnExpressions2 = ((UBlockExpression)uExpression3).getExpressions().stream().filter(findBaseUrl.returnExpressions.1.INSTANCE).map(findBaseUrl.returnExpressions.2.INSTANCE).collect(Collectors.toList());
            for (UReturnExpression returnExpression : returnExpressions2) {
                String baseUrl = this.findBaseUrl(returnExpression.getReturnExpression());
                if (baseUrl == null) continue;
                return baseUrl;
            }
        }
        return null;
    }

    @NotNull
    protected abstract UCallExpressionPattern getWebClientCreatePattern();

    @NotNull
    protected abstract UCallExpressionPattern getWebClientBuilderUrlPattern();

    @NotNull
    protected abstract UCallExpressionPattern getHttpMethodsPattern();

    @NotNull
    protected abstract UCallExpressionPattern getHttpMethodPattern();

    @Override
    @Nullable
    public String findHttpMethod(@NotNull UCallExpression urlNode) {
        String httpMethod;
        String string;
        Intrinsics.checkNotNullParameter((Object)urlNode, (String)"urlNode");
        UQualifiedReferenceExpression uQualifiedReferenceExpression = UastUtils.getOutermostQualified((UExpression)((UExpression)urlNode));
        if (uQualifiedReferenceExpression == null) {
            return null;
        }
        UExpression parent = (UExpression)uQualifiedReferenceExpression;
        UCallExpression firstCallExpressionsInChain = SpringFunctionalRoutingUastUtil.findFirstCallExpressionsInChain(parent, this.getHttpMethodsPattern());
        Object object = firstCallExpressionsInChain;
        if (object != null && (object = object.resolve()) != null && (object = object.getName()) != null) {
            Object object2 = object;
            boolean bl = false;
            Object object3 = object2;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object3).toUpperCase();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        } else {
            string = httpMethod = null;
        }
        if (httpMethod != null) {
            return httpMethod;
        }
        firstCallExpressionsInChain = SpringFunctionalRoutingUastUtil.findFirstCallExpressionsInChain(parent, this.getHttpMethodPattern());
        if (firstCallExpressionsInChain != null) {
            UExpression expressionType = firstCallExpressionsInChain.getArgumentForParameter(0);
            if (expressionType instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)expressionType).getResolvedName();
            }
            if (expressionType instanceof UQualifiedReferenceExpression) {
                return ((UQualifiedReferenceExpression)expressionType).getResolvedName();
            }
        }
        return null;
    }
}

